/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.geometry;

import dev.boxadactle.boxlib.math.geometry.Vec2;

public class Rect<T extends Number> {
    public T x;
    public T y;
    public T width;
    public T height;

    public Rect(T x, T y, T width, T height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public T getX() {
        return this.x;
    }

    public T getY() {
        return this.y;
    }

    public T getWidth() {
        return this.width;
    }

    public T getHeight() {
        return this.height;
    }

    public int getMaxX() {
        return (Integer)this.x + (Integer)this.width;
    }

    public int getMaxY() {
        return (Integer)this.y + (Integer)this.height;
    }

    public int getCenterY() {
        return (Integer)this.y + (Integer)this.height / 2;
    }

    public void setX(T x) {
        this.x = x;
    }

    public void setY(T y) {
        this.y = y;
    }

    public void setWidth(T width) {
        this.width = width;
    }

    public void setHeight(T height) {
        this.height = height;
    }

    public double getArea() {
        return (Double)this.width * (Double)this.height;
    }

    public double calculateDiagonalLength() {
        return Math.sqrt((Double)this.width * (Double)this.width + (Double)this.height * (Double)this.height);
    }

    public T getPerimeter() {
        Double perimeter = (((Number)this.width).doubleValue() + ((Number)this.height).doubleValue()) * 2.0;
        return (T)perimeter;
    }

    public boolean containsPoint(Vec2<T> point) {
        double pointX = ((Number)point.getX()).doubleValue();
        double pointY = ((Number)point.getY()).doubleValue();
        double rectMinX = ((Number)this.x).doubleValue();
        double rectMaxX = ((Number)this.x).doubleValue() + ((Number)this.width).doubleValue();
        double rectMinY = ((Number)this.y).doubleValue();
        double rectMaxY = ((Number)this.y).doubleValue() + ((Number)this.height).doubleValue();
        return pointX >= rectMinX && pointX <= rectMaxX && pointY >= rectMinY && pointY <= rectMaxY;
    }

    public Rect<T> clone() {
        return new Rect<T>(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return "Rect{x=" + String.valueOf(this.x) + ", y=" + String.valueOf(this.y) + ", width=" + String.valueOf(this.width) + ", height=" + String.valueOf(this.height) + "}";
    }
}

