/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.mathutils;

import dev.boxadactle.boxlib.math.geometry.Rect;

public class Clamps {
    public static byte clamp(byte value, byte min, byte max) {
        if (value < min) {
            return min;
        }
        return value > max ? max : value;
    }

    public static int clamp(int value, int min, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static long clamp(long value, long min, long max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static float clamp(float value, float min, float max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static double clamp(double value, double min, double max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    public static Rect<Double> clampRect(double innerX, double innerY, double innerWidth, double innerHeight, double outerX, double outerY, double outerWidth, double outerHeight) {
        double clampedX = Clamps.clamp(innerX, outerX, outerX + outerWidth - innerWidth);
        double clampedY = Clamps.clamp(innerY, outerY, outerY + outerHeight - innerHeight);
        return new Rect<Double>(clampedX, clampedY, innerWidth, innerHeight);
    }

    public static Rect<Float> clampRect(float innerX, float innerY, float innerWidth, float innerHeight, float outerX, float outerY, float outerWidth, float outerHeight) {
        float clampedX = Clamps.clamp(innerX, outerX, outerX + outerWidth - innerWidth);
        float clampedY = Clamps.clamp(innerY, outerY, outerY + outerHeight - innerHeight);
        return new Rect<Float>(Float.valueOf(clampedX), Float.valueOf(clampedY), Float.valueOf(innerWidth), Float.valueOf(innerHeight));
    }

    public static Rect<Integer> clampRect(int innerX, int innerY, int innerWidth, int innerHeight, int outerX, int outerY, int outerWidth, int outerHeight) {
        int clampedX = Clamps.clamp(innerX, outerX, outerX + outerWidth - innerWidth);
        int clampedY = Clamps.clamp(innerY, outerY, outerY + outerHeight - innerHeight);
        return new Rect<Integer>(clampedX, clampedY, innerWidth, innerHeight);
    }

    public static Rect<Long> clampRect(long innerX, long innerY, long innerWidth, long innerHeight, long outerX, long outerY, long outerWidth, long outerHeight) {
        long clampedX = Clamps.clamp(innerX, outerX, outerX + outerWidth - innerWidth);
        long clampedY = Clamps.clamp(innerY, outerY, outerY + outerHeight - innerHeight);
        return new Rect<Long>(clampedX, clampedY, innerWidth, innerHeight);
    }
}

