/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.mathutils;

public class Lerps {
    public static double lerp(double a, double b, double t) {
        return a + (b - a) * t;
    }

    public static double lerpCircular(double a, double b, double t) {
        return (1.0 - t) * a + t * b;
    }

    public static double clampedLerp(double start, double end, double delta) {
        if (delta < 0.0) {
            return start;
        }
        return delta > 1.0 ? end : Lerps.lerp(delta, start, end);
    }

    public static float clampedLerp(float start, float end, float delta) {
        if (delta < 0.0f) {
            return start;
        }
        return delta > 1.0f ? end : (float)Lerps.lerp(delta, start, end);
    }
}

