/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.rendering.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.boxadactle.boxlib.math.geometry.Box;
import dev.boxadactle.boxlib.rendering.Renderer3D;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;
import org.joml.Matrix4f;

public class BoxRenderer
extends Renderer3D<BoxRenderer> {
    AABB box;

    public BoxRenderer(boolean disposeNextFrame) {
        super(disposeNextFrame);
    }

    public BoxRenderer setCube(AABB cube) {
        this.box = cube;
        return this;
    }

    public BoxRenderer setCube(AABB cube, double expand) {
        AABB inflated = cube.inflate(expand);
        return this.setCube(inflated);
    }

    public BoxRenderer setCube(Box<Double> cube) {
        return this.setCube(new AABB(cube.minX().doubleValue(), cube.minY().doubleValue(), cube.minZ().doubleValue(), cube.maxX().doubleValue(), cube.maxY().doubleValue(), cube.maxZ().doubleValue()));
    }

    public BoxRenderer setCube(BlockPos pos) {
        return this.setCube(new AABB(pos));
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource.BufferSource buffer, double cameraX, double cameraY, double cameraZ) {
        VertexConsumer consumer = buffer.getBuffer(RenderType.debugFilledBox());
        AABB box = this.box.move(this.getCamera().getPosition().reverse());
        Matrix4f matrix = stack.last().pose();
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.minY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.minY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.minX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.minZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
        consumer.addVertex(matrix, (float)box.maxX, (float)box.maxY, (float)box.maxZ).setColor(this.r, this.g, this.b, this.a);
    }
}

