/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.test.config;

import dev.boxadactle.boxlib.gui.ConfigGuiBuilder;
import dev.boxadactle.boxlib.gui.auto.AutoConfigGui;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.BCustomEntry;
import dev.boxadactle.boxlib.gui.config.widget.BSpacingEntry;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BColorPickerButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BEnumButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BScreenButton;
import dev.boxadactle.boxlib.gui.config.widget.field.BArgbField;
import dev.boxadactle.boxlib.gui.config.widget.field.BDoubleField;
import dev.boxadactle.boxlib.gui.config.widget.field.BFloatField;
import dev.boxadactle.boxlib.gui.config.widget.field.BIntegerField;
import dev.boxadactle.boxlib.gui.config.widget.field.BLongField;
import dev.boxadactle.boxlib.gui.config.widget.field.BShortField;
import dev.boxadactle.boxlib.gui.config.widget.field.BStringField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.gui.config.widget.slider.BDoubleSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BFloatSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BLongSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BShortSlider;
import dev.boxadactle.boxlib.layouts.RenderingLayout;
import dev.boxadactle.boxlib.layouts.component.LayoutContainerComponent;
import dev.boxadactle.boxlib.layouts.component.ParagraphComponent;
import dev.boxadactle.boxlib.layouts.layout.ColumnLayout;
import dev.boxadactle.boxlib.layouts.layout.RowLayout;
import dev.boxadactle.boxlib.prompt.Prompts;
import dev.boxadactle.boxlib.test.TestMod;
import dev.boxadactle.boxlib.test.config.ExampleConfigClass;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ExampleConfigScreen
extends BOptionScreen {
    public ExampleConfigScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"boxlib.exampleconfigscreen"));
        TestMod.CONFIG.cacheConfig();
    }

    @Override
    protected int getRowWidth() {
        return super.getRowWidth() + 100;
    }

    @Override
    protected int getRowHeight() {
        return super.getRowHeight() + 20;
    }

    @Override
    protected int getScrollbarX() {
        return this.width - 15;
    }

    private ExampleConfigClass config() {
        return (ExampleConfigClass)TestMod.CONFIG.get();
    }

    @Override
    protected void initFooter(LinearLayout layout) {
        layout.addChild((LayoutElement)this.createCancelButton(b -> {
            ClientUtils.setScreen(this.parent);
            TestMod.CONFIG.restoreCache();
        }));
        this.setSaveButton((Button)layout.addChild((LayoutElement)this.createSaveButton(b -> {
            TestMod.CONFIG.save();
            ClientUtils.setScreen(this.parent);
        })));
        this.setWiki((Component)Component.translatable((String)"boxlib.wiki"), "https://github.com/Boxadactle/boxlib");
    }

    protected void addOptions() {
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.anArgbField")));
        this.addConfigLine(new BArgbField(this.config().anArgbColor, newVal -> {
            this.config().anArgbColor = newVal;
        }));
        this.addConfigLine(new BColorPickerButton("boxlib.colorpicker", (Screen)this, false, this.config().aColorPicker, newVal -> {
            this.config().aColorPicker = newVal;
        }));
        this.addConfigLine(new BColorPickerButton("boxlib.colorpicker.alpha", (Screen)this, true, this.config().aColorPickerwAlpha, newVal -> {
            this.config().aColorPickerwAlpha = newVal;
        }));
        this.addConfigLine(new BBooleanButton("boxlib.aBoolean", this.config().aBoolean, newVal -> {
            this.config().aBoolean = newVal;
        }), new BEnumButton<ExampleConfigClass.ExampleEnum>("boxlib.anEnum", this.config().anEnum, ExampleConfigClass.ExampleEnum.class, newVal -> {
            this.config().anEnum = newVal;
        }, GuiUtils.BLUE));
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.aDouble")), new BCenteredLabel((Component)Component.translatable((String)"boxlib.aFloat")));
        this.addConfigLine(new BDoubleField(this.config().aDouble, newVal -> {
            this.config().aDouble = newVal;
        }), new BFloatField(Float.valueOf(this.config().aFloat), newVal -> {
            this.config().aFloat = newVal.floatValue();
        }));
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.aHexColor")));
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.anInt")));
        this.addConfigLine(new BIntegerField(this.config().anInt, newVal -> {
            this.config().anInt = newVal;
        }));
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.aString")));
        this.addConfigLine(new BStringField(this.config().aString, newVal -> {
            this.config().aString = newVal;
        }));
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.aLong")));
        this.addConfigLine(new BLongField(this.config().aLong, newVal -> {
            this.config().aLong = newVal;
        }));
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.aLong")));
        this.addConfigLine(new BLongField(this.config().aLong, newVal -> {
            this.config().aLong = newVal;
        }));
        this.addConfigLine(new BCenteredLabel((Component)Component.translatable((String)"boxlib.aShort")));
        this.addConfigLine(new BShortField(this.config().aShort, newVal -> {
            this.config().aShort = newVal;
        }));
        this.addConfigLine(new BDoubleSlider("boxlib.anotherDouble", 0.0, 100.0, this.config().anotherDouble, 5, newVal -> {
            this.config().anotherDouble = newVal;
        }), new BFloatSlider("boxlib.anotherFloat", 0.0f, 50.0f, this.config().anotherFloat, 3, newVal -> {
            this.config().anotherFloat = newVal.floatValue();
        }));
        this.addConfigLine(new BIntegerSlider("boxlib.anotherInt", 0, 10, this.config().anotherInt, newVal -> {
            this.config().anotherInt = newVal;
        }));
        this.addConfigLine(new BLongSlider("boxlib.anotherLong", 100L, 5000L, this.config().anotherLong, newVal -> {
            this.config().anotherLong = newVal;
        }));
        this.addConfigLine(new BShortSlider("boxlib.anotherShort", 10, 1000, this.config().anotherShort, newVal -> {
            this.config().anotherShort = newVal;
        }));
        this.addConfigLine(new BScreenButton((Component)Component.translatable((String)"boxlib.aConfigScreen"), (Screen)this, this::createPromptTestingScreen), new BScreenButton((Component)Component.translatable((String)"boxlib.autoconfigscreen"), (Screen)this, this::createAutoGui));
        RenderingLayout layout = this.createLayout();
        this.addConfigLine(new BCustomEntry((guiGraphics, x, y, width, height, mouseX, mouseY, tickDelta) -> {
            layout.setPosition((int)x, (int)y);
            layout.render((GuiGraphics)guiGraphics);
        }));
        for (int i = 0; i < 10; ++i) {
            this.addConfigLine(new BSpacingEntry());
        }
    }

    public BOptionScreen createAutoGui(Screen parent) {
        return AutoConfigGui.start(TestMod.CONFIG2.get(), parent).setFooterProvider((layout, s) -> (Button)layout.addChild((LayoutElement)this.setSaveButton(this.createSaveButton(b -> {
            TestMod.CONFIG2.save();
            ClientUtils.setScreen(s);
        })))).build();
    }

    public BOptionScreen createPromptTestingScreen(Screen parent) {
        return ConfigGuiBuilder.builder(parent, (Component)Component.literal((String)"Prompt Testing")).addButton((Component)Component.literal((String)"Test Alert"), () -> Prompts.alert((Screen)this, (Component)Component.literal((String)"This is a test alert!"))).addButton((Component)Component.literal((String)"Test Confirm"), () -> Prompts.confirm((Screen)this, (Component)Component.literal((String)"This is a test confirm!"), b -> ClientUtils.showToast((Component)Component.literal((String)"Response"), (Component)Component.literal((String)("Confirmed: " + b))))).addButton((Component)Component.literal((String)"Test Prompt"), () -> Prompts.prompt((Screen)this, (Component)Component.literal((String)"This is a test prompt!"), s -> ClientUtils.showToast((Component)Component.literal((String)"Response"), (Component)Component.literal((String)("Responded with: " + s))))).addButton((Component)Component.literal((String)"Test Integer Prompt"), () -> Prompts.promptInteger((Screen)this, (Component)Component.literal((String)"This is a test integer prompt!"), i -> ClientUtils.showToast((Component)Component.literal((String)"Response"), (Component)Component.literal((String)("Responded with: " + i))))).addEntry(new BSpacingEntry()).addLabel((Component)Component.literal((String)"This is a label!")).addInput("This is a string field!", s -> ClientUtils.showToast((Component)Component.literal((String)"Response"), (Component)Component.literal((String)("Responded with: " + s)))).addDoubleEntry(new BStringField("This is a", d -> {}), new BStringField("double entry!", f -> {})).setFooterProvider(this::createDoneButton).build();
    }

    private RenderingLayout createLayout() {
        RowLayout layout = new RowLayout(0, 0, 10);
        layout.addComponent(new ParagraphComponent(2, new Component[]{Component.literal((String)"This is a paragraph component. "), Component.literal((String)"It's a simple way to add text to a layout."), Component.literal((String)"You can add as many components as you want."), Component.literal((String)"And it will render them all in a line.")}));
        ColumnLayout verticalLayout = new ColumnLayout(0, 0, 10);
        for (int i = 0; i < 5; ++i) {
            verticalLayout.addComponent(new ParagraphComponent(2, new Component[]{Component.literal((String)"This is a paragraph component. "), Component.literal((String)"It's a simple way to add text to a layout.")}));
        }
        layout.addComponent(new LayoutContainerComponent(verticalLayout));
        return layout;
    }
}

