/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import dev.boxadactle.boxlib.function.EmptyMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClientUtils {
    public static Minecraft getClient() {
        return Minecraft.getInstance();
    }

    public static Options getOptions() {
        return ClientUtils.getClient().options;
    }

    public static String parseIdentifier(String id) {
        StringBuilder name = new StringBuilder();
        String withoutNamespace = id.split(":")[1];
        String spaces = withoutNamespace.replaceAll("_", " ");
        for (String word : spaces.split("\\s")) {
            String firstLetter = word.substring(0, 1);
            String theRest = word.substring(1);
            name.append(firstLetter.toUpperCase()).append(theRest).append(" ");
        }
        return name.toString().trim();
    }

    public static long getWindow() {
        return ClientUtils.getClient().getWindow().handle();
    }

    public static String getGameVersion() {
        return SharedConstants.getCurrentVersion().name();
    }

    public static KeyboardHandler getKeyboard() {
        return ClientUtils.getClient().keyboardHandler;
    }

    public static Screen getCurrentScreen() {
        return ClientUtils.getClient().screen;
    }

    public static Screen setScreen(Screen newScreen) {
        ClientUtils.getClient().setScreen(newScreen);
        return newScreen;
    }

    public static void openUrl(String url) {
        try {
            URI uri = new URI(url);
            Util.getPlatform().openUri(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed URL: " + url, e);
        }
    }

    public static void openLinkConfirmScreen(String link, Screen parent) {
        ClientUtils.getClient().setScreen((Screen)new ConfirmLinkScreen(open -> {
            if (open) {
                ClientUtils.openUrl(link);
            }
            ClientUtils.setScreen(parent);
        }, link, true));
    }

    public static void confirm(Component message, Component description, EmptyMethod yes, EmptyMethod no) {
        ClientUtils.getClient().setScreen((Screen)new ConfirmScreen(b -> {
            if (b) {
                yes.accept();
            } else {
                no.accept();
            }
        }, message, description));
    }

    public static void showToast(Component message, Component description) {
        SystemToast.addOrUpdate((ToastManager)ClientUtils.getClient().getToastManager(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)message, (Component)description);
    }

    public static Path getConfigFolder() {
        return Path.of(ClientUtils.getClient().gameDirectory.getAbsolutePath() + "/config", new String[0]);
    }
}

