/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import dev.boxadactle.boxlib.util.ClientUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;

public class GuiUtils {
    public static final int AUTO = -1;
    public static final int BLACK = GuiUtils.applyAlpha(0, 1.0f);
    public static final int DARK_BLUE = GuiUtils.applyAlpha(170, 1.0f);
    public static final int DARK_GREEN = GuiUtils.applyAlpha(43520, 1.0f);
    public static final int DARK_AQUA = GuiUtils.applyAlpha(43690, 1.0f);
    public static final int DARK_RED = GuiUtils.applyAlpha(0xAA0000, 1.0f);
    public static final int DARK_PURPLE = GuiUtils.applyAlpha(0xAA00AA, 1.0f);
    public static final int GOLD = GuiUtils.applyAlpha(0xFFAA00, 1.0f);
    public static final int GRAY = GuiUtils.applyAlpha(0xAAAAAA, 1.0f);
    public static final int DARK_GRAY = GuiUtils.applyAlpha(0x555555, 1.0f);
    public static final int BLUE = GuiUtils.applyAlpha(0x5555FF, 1.0f);
    public static final int GREEN = GuiUtils.applyAlpha(0x55FF55, 1.0f);
    public static final int AQUA = GuiUtils.applyAlpha(0x55FFFF, 1.0f);
    public static final int RED = GuiUtils.applyAlpha(0xFF5555, 1.0f);
    public static final int LIGHT_PURPLE = GuiUtils.applyAlpha(0xFF55FF, 1.0f);
    public static final int YELLOW = GuiUtils.applyAlpha(0xFFFF55, 1.0f);
    public static final int WHITE = GuiUtils.applyAlpha(0xFFFFFF, 1.0f);
    public static Component ON;
    public static Component OFF;
    public static Component DONE;
    public static Component CANCEL;
    public static Component YES;
    public static Component NO;
    public static Component OK;
    public static Component ALL;
    public static Component BACK;
    public static Component SAVE;
    public static Component LOAD;
    public static Component REFRESH;
    public static Component ACCEPT;
    public static Component REJECT;
    public static Component ERROR_OCCURED;
    public static Component TRUE;
    public static Component FALSE;

    public static void init() {
        ON = Component.translatable((String)"options.on");
        OFF = Component.translatable((String)"options.off");
        DONE = Component.translatable((String)"gui.done");
        CANCEL = Component.translatable((String)"gui.cancel");
        YES = Component.translatable((String)"gui.yes");
        NO = Component.translatable((String)"gui.no");
        OK = Component.translatable((String)"gui.ok");
        ALL = Component.translatable((String)"gui.all");
        BACK = Component.translatable((String)"gui.back");
        SAVE = Component.translatable((String)"structure_block.mode.save");
        LOAD = Component.translatable((String)"structure_block.mode.load");
        REFRESH = Component.translatable((String)"selectServer.refresh");
        ACCEPT = Component.translatable((String)"mco.invites.button.accept");
        REJECT = Component.translatable((String)"mco.invites.button.reject");
        ERROR_OCCURED = Component.translatable((String)"selectWorld.futureworld.error.title");
        TRUE = GuiUtils.colorize(YES, GREEN);
        FALSE = GuiUtils.colorize(NO, RED);
    }

    public static String getTranslatable(String key) {
        return Language.getInstance().getOrDefault(key);
    }

    public static Component colorize(Component text, int color) {
        return text.copy().withStyle(style -> style.withColor(color));
    }

    @Deprecated
    public static int getColorDecimal(String color) {
        String c;
        return switch (c = color.toLowerCase(Locale.ROOT)) {
            case "dark_red" -> DARK_RED;
            case "red" -> RED;
            case "gold" -> GOLD;
            case "yellow" -> YELLOW;
            case "dark_green" -> DARK_GREEN;
            case "green" -> GREEN;
            case "aqua" -> AQUA;
            case "dark_aqua" -> DARK_AQUA;
            case "dark_blue" -> DARK_BLUE;
            case "blue" -> BLUE;
            case "light_purple" -> LIGHT_PURPLE;
            case "dark_purple" -> DARK_PURPLE;
            case "white" -> WHITE;
            case "gray" -> GRAY;
            case "dark_gray" -> DARK_GRAY;
            case "black" -> BLACK;
            default -> WHITE;
        };
    }

    public static int applyAlpha(int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        return color & 0xFFFFFF | a << 24;
    }

    public static int getTextSize(Component text) {
        return GuiUtils.getTextRenderer().width((FormattedText)text);
    }

    public static int getTextHeight() {
        Objects.requireNonNull(ClientUtils.getClient().font);
        return 9;
    }

    public static int getLongestLength(Component ... text) {
        int largest = 0;
        Font textRenderer = GuiUtils.getTextRenderer();
        for (Component value : text) {
            int t = textRenderer.width((FormattedText)value);
            if (t <= largest) continue;
            largest = t;
        }
        return largest;
    }

    public static int getShortestLength(Component ... text) {
        int shortest = 0;
        Font textRenderer = GuiUtils.getTextRenderer();
        shortest = textRenderer.width((FormattedText)text[0]);
        for (Component value : text) {
            int t = textRenderer.width((FormattedText)value);
            if (t >= shortest) continue;
            shortest = t;
        }
        return shortest;
    }

    public static int getLongestWidget(AbstractWidget ... widgets) {
        int longest = 0;
        for (AbstractWidget widget : widgets) {
            int t = widget.getWidth();
            if (t <= longest) continue;
            longest = t;
        }
        return longest;
    }

    public static Component createHyperLink(Component text, String link) {
        return text.copy().withStyle(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.BLUE}).withStyle(a1 -> {
            try {
                return a1.withClickEvent((ClickEvent)new ClickEvent.OpenUrl(new URI(link))).withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"chat.link.open")));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static int getTallestWidget(AbstractWidget ... widgets) {
        int tallest = 0;
        for (AbstractWidget widget : widgets) {
            int t = widget.getHeight();
            if (t <= tallest) continue;
            tallest = t;
        }
        return tallest;
    }

    public static int nonZeroGuiScale() {
        int scale = (Integer)ClientUtils.getOptions().guiScale().get();
        Minecraft client = ClientUtils.getClient();
        if (scale == 0) {
            return (int)Math.max(1.0, Math.min(Math.floor(client.getWindow().getGuiScaledWidth() / 320), Math.floor(client.getWindow().getGuiScaledHeight() / 240)));
        }
        return scale;
    }

    public static Component surround(String str1, String str2, Component input) {
        return Component.literal((String)str1).append(input).append((Component)Component.literal((String)str2));
    }

    public static Component parentheses(Component input) {
        return GuiUtils.surround("(", ")", input);
    }

    public static Component brackets(Component input) {
        return GuiUtils.surround("[", "]", input);
    }

    public static Component quotes(Component input) {
        return GuiUtils.surround("\"", "\"", input);
    }

    public static Font getTextRenderer() {
        return ClientUtils.getClient().font;
    }
}

