/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui;

import dev.boxadactle.boxlib.function.Function2;
import dev.boxadactle.boxlib.gui.config.BConfigList;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.button.BCustomButton;
import dev.boxadactle.boxlib.gui.config.widget.field.BStringField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigGuiBuilder {
    public static Builder builder(Screen parent, Component name) {
        return new Builder(parent, name);
    }

    public static Builder builder(Component name) {
        return new Builder(null, name);
    }

    public static class Builder {
        Component name;
        Screen parent;
        List<BConfigList.ConfigEntry> entries = new ArrayList<BConfigList.ConfigEntry>();
        Function2<LinearLayout, Screen, Button> footerProvider;

        public Builder(Screen parent, Component name) {
            this.parent = parent;
            this.name = name;
        }

        public Builder addEntry(BOptionEntry<?> entry) {
            this.entries.add(new BConfigList.SingleEntry(entry));
            return this;
        }

        public Builder addCustomEntry(BConfigList.ConfigEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder addDoubleEntry(BOptionEntry<?> entry1, BOptionEntry<?> entry2) {
            this.entries.add(new BConfigList.DoubleEntry(entry1, entry2));
            return this;
        }

        public Builder addButton(Component message, Runnable onClick) {
            this.entries.add(new BConfigList.SingleEntry(BCustomButton.create(message, onClick)));
            return this;
        }

        public Builder addLabel(Component message) {
            this.entries.add(new BConfigList.SingleEntry(new BCenteredLabel(message)));
            return this;
        }

        public Builder addInput(String value, Consumer<String> consumer) {
            this.entries.add(new BConfigList.SingleEntry(new BStringField(value, consumer)));
            return this;
        }

        public Builder setFooterProvider(Function2<LinearLayout, Screen, Button> footerProvider) {
            this.footerProvider = footerProvider;
            return this;
        }

        public Builder setFooterProvider(Function<Screen, Button> footerProvider) {
            return this.setFooterProvider((LinearLayout layout, Screen screen) -> (Button)layout.addChild((LayoutElement)((Button)footerProvider.apply((Screen)screen))));
        }

        public BOptionScreen build() {
            return new BOptionScreen(this.parent, this.name){

                @Override
                protected void initFooter(LinearLayout layout) {
                    if (footerProvider != null) {
                        footerProvider.accept(layout, this.parent);
                    } else {
                        layout.addChild((LayoutElement)this.createDoneButton(this.parent));
                    }
                }

                protected void addOptions() {
                    entries.forEach(x$0 -> this.addConfigLine(x$0));
                }
            };
        }
    }
}

