/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.config;

import com.google.common.collect.ImmutableList;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;

public class BConfigList
extends ContainerObjectSelectionList<ConfigEntry>
implements LayoutElement {
    BOptionScreen screen;

    public BConfigList(Minecraft minecraft, BOptionScreen screen) {
        super(minecraft, screen.width, screen.layout.getContentHeight(), screen.layout.getHeaderHeight(), screen.getRowHeight());
        this.screen = screen;
    }

    public int getRowWidth() {
        return this.screen.getRowWidth();
    }

    protected int scrollBarX() {
        return this.screen.getScrollbarX();
    }

    public int addEntry(ConfigEntry entry) {
        return super.addEntry((AbstractSelectionList.Entry)entry);
    }

    public boolean hasInvalidEntry() {
        AtomicBoolean a = new AtomicBoolean(false);
        this.children().forEach(configWidgetEntry -> {
            if (configWidgetEntry.isInvalid()) {
                a.set(true);
            }
        });
        return a.get();
    }

    public static abstract class ConfigEntry
    extends ContainerObjectSelectionList.Entry<ConfigEntry> {
        public List<? extends NarratableEntry> narratables() {
            return this.getWidgets();
        }

        public List<? extends GuiEventListener> children() {
            return this.getWidgets();
        }

        public abstract List<? extends AbstractWidget> getWidgets();

        public abstract boolean isInvalid();
    }

    public static class DoubleEntry
    extends ConfigEntry {
        BOptionEntry<?> widget1;
        BOptionEntry<?> widget2;

        public DoubleEntry(BOptionEntry<?> widget1, BOptionEntry<?> widget2) {
            this.widget1 = widget1;
            this.widget2 = widget2;
        }

        @Override
        public List<? extends AbstractWidget> getWidgets() {
            return ImmutableList.of((Object)((AbstractWidget)this.widget1), (Object)((AbstractWidget)this.widget2));
        }

        @Override
        public boolean isInvalid() {
            return this.widget1.isInvalid() || this.widget2.isInvalid();
        }

        public void renderContent(GuiGraphics guiGraphics, int i, int j, boolean bl, float f) {
            AbstractWidget w1 = (AbstractWidget)this.widget1;
            AbstractWidget w2 = (AbstractWidget)this.widget2;
            int p1 = BOptionHelper.padding() / 2;
            int p2 = BOptionHelper.padding() / 2;
            w1.setX(this.getX());
            w1.setY(this.getY());
            w1.setWidth(this.getWidth() / 2 - p1);
            w2.setX(this.getX() + this.getWidth() / 2 + p2);
            w2.setY(this.getY());
            w2.setWidth(this.getWidth() / 2 - p2);
            w1.render(guiGraphics, i, j, f);
            w2.render(guiGraphics, i, j, f);
        }
    }

    public static class SingleEntry
    extends ConfigEntry {
        BOptionEntry<?> widget;

        public SingleEntry(BOptionEntry<?> widget) {
            this.widget = widget;
        }

        public void renderContent(GuiGraphics guiGraphics, int i, int j, boolean bl, float f) {
            AbstractWidget w = (AbstractWidget)this.widget;
            w.setX(this.getX());
            w.setY(this.getY());
            w.setWidth(this.getWidth());
            w.render(guiGraphics, i, j, f);
        }

        @Override
        public List<? extends AbstractWidget> getWidgets() {
            return ImmutableList.of((Object)((AbstractWidget)this.widget));
        }

        @Override
        public boolean isInvalid() {
            return this.widget.isInvalid();
        }
    }
}

