/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.prompt.gui;

import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.prompt.PromptScreen;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.RenderUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class NumberScreen<T extends Number>
extends PromptScreen<T> {
    EditBox inputBox;
    Component message;

    public NumberScreen(Screen parent, Component message) {
        super(parent);
        this.message = message;
    }

    @Nullable
    protected abstract T parse(String var1);

    @Override
    protected T getData() {
        return this.parse(this.inputBox.getValue());
    }

    @Override
    protected boolean allowContinue() {
        try {
            return this.inputBox != null && !this.inputBox.getValue().isBlank() && this.parse(this.inputBox.getValue()) != null;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected void init() {
        this.layout.addTitleHeader(this.message, GuiUtils.getTextRenderer());
        this.inputBox = (EditBox)this.layout.addToContents((LayoutElement)new EditBox(this.font, this.width / 2 - 150, this.height / 2 - 10, 300, 20, (Component)Component.literal((String)"Input box")));
        super.init();
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        if (this.inputBox != null && !this.allowContinue()) {
            RenderUtils.drawSquare(guiGraphics, new Rect<Integer>(this.inputBox.getX(), this.inputBox.getY(), this.inputBox.getWidth(), this.inputBox.getHeight()), GuiUtils.applyAlpha(GuiUtils.RED, 0.4f));
        }
    }
}

