/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.command.api;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.boxadactle.boxlib.command.BCommandManager;
import dev.boxadactle.boxlib.command.BCommandSourceStack;
import dev.boxadactle.boxlib.command.api.BSubcommand;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class BCommand {
    protected String commandName;
    protected Function<CommandContext<BCommandSourceStack>, Integer> rootCommand;
    protected List<BSubcommand> subcommands;

    public static BCommand create(String commandName, Function<CommandContext<BCommandSourceStack>, Integer> rootCommand) {
        return new BCommand(commandName, rootCommand);
    }

    public static BCommand create(String commandName) {
        return new BCommand(commandName, context -> 0);
    }

    protected BCommand(String commandName, Function<CommandContext<BCommandSourceStack>, Integer> rootCommand) {
        this.commandName = commandName;
        this.rootCommand = rootCommand;
        this.subcommands = new ArrayList<BSubcommand>();
    }

    public void register(CommandDispatcher<BCommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)BCommandManager.literal(this.commandName).executes(this.rootCommand::apply);
        for (BSubcommand subcommand : this.subcommands) {
            root.then(subcommand.buildSubcommand());
        }
        dispatcher.register(root);
    }

    public BCommand registerSubcommand(BSubcommand subcommand) {
        this.subcommands.add(subcommand);
        return this;
    }
}

