/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.prompt;

import dev.boxadactle.boxlib.function.EmptyMethod;
import dev.boxadactle.boxlib.prompt.PromptScreen;
import dev.boxadactle.boxlib.prompt.gui.AlertScreen;
import dev.boxadactle.boxlib.prompt.gui.ConfirmScreen;
import dev.boxadactle.boxlib.prompt.gui.InputScreen;
import dev.boxadactle.boxlib.prompt.gui.number.IntegerScreen;
import dev.boxadactle.boxlib.util.ClientUtils;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class Prompts {
    public static <T> void showPrompt(PromptScreenProvider<T> promptScreenClass, Screen parent, Component message, Consumer<T> dataConsumer, EmptyMethod noData) {
        PromptScreen<Object> screen = promptScreenClass.get(parent, message);
        screen.onData((b, data) -> {
            if (b.booleanValue()) {
                dataConsumer.accept(data);
            } else {
                noData.accept();
            }
        });
        ClientUtils.setScreen(screen);
    }

    public static void alert(Screen parent, Component message) {
        Prompts.showPrompt(AlertScreen::new, parent, message, data -> {}, () -> {});
    }

    public static void confirm(Screen parent, Component message, Consumer<Boolean> consumer) {
        Prompts.showPrompt(ConfirmScreen::new, parent, message, consumer, () -> consumer.accept(false));
    }

    public static void prompt(Screen parent, Component message, Consumer<String> consumer) {
        Prompts.showPrompt(InputScreen::new, parent, message, consumer, () -> consumer.accept(""));
    }

    public static <T extends Number> void promptNumber(PromptScreenProvider<T> provider, Screen parent, Component message, Consumer<T> consumer) {
        Prompts.showPrompt(provider, parent, message, consumer::accept, () -> consumer.accept(null));
    }

    public static void promptInteger(Screen parent, Component message, Consumer<Integer> consumer) {
        Prompts.promptNumber(IntegerScreen::new, parent, message, consumer);
    }

    @FunctionalInterface
    public static interface PromptScreenProvider<T> {
        public PromptScreen<T> get(Screen var1, Component var2);
    }
}

