/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;

public abstract class Renderer3D<T> {
    protected boolean disposeNextFrame;
    protected float r;
    protected float g;
    protected float b;
    protected float a;

    public Renderer3D(boolean disposeNextFrame) {
        this.disposeNextFrame = disposeNextFrame;
    }

    public abstract void render(PoseStack var1, MultiBufferSource.BufferSource var2, double var3, double var5, double var7);

    public boolean disposeNextFrame() {
        return this.disposeNextFrame;
    }

    public T setColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        return (T)this;
    }

    public T setColor(float r, float g, float b) {
        return this.setColor(r, g, b, 1.0f);
    }

    public T setColor(int rgb) {
        return this.setColor((float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
    }

    public T setRed(float r) {
        this.r = r;
        return (T)this;
    }

    public T setGreen(float g) {
        this.g = g;
        return (T)this;
    }

    public T setBlue(float b) {
        this.b = b;
        return (T)this;
    }

    public T setAlpha(float a) {
        this.a = a;
        return (T)this;
    }

    protected Minecraft getMinecraft() {
        return Minecraft.getInstance();
    }

    protected Camera getCamera() {
        return this.getMinecraft().gameRenderer.getMainCamera();
    }
}

