/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.rendering.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.rendering.Renderer3D;
import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import java.awt.Color;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import org.joml.Quaternionfc;

public class TextRenderer
extends Renderer3D<TextRenderer> {
    Vec3<Double> pos;
    Component text;
    float size = 0.02f;
    boolean centered = true;
    float offset = 0.0f;
    boolean xray = false;
    boolean shadow = false;

    public TextRenderer(boolean disposeNextFrame) {
        super(disposeNextFrame);
    }

    public TextRenderer setPos(Vec3<Double> pos) {
        this.pos = pos;
        return this;
    }

    public TextRenderer setText(Component text) {
        this.text = text;
        return this;
    }

    public TextRenderer setSize(float size) {
        this.size = size;
        return this;
    }

    public TextRenderer setCentered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public TextRenderer setOffset(float offset) {
        this.offset = offset;
        return this;
    }

    public TextRenderer setXray(boolean xray) {
        this.xray = xray;
        return this;
    }

    public TextRenderer setShadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    private int getColor() {
        return new Color(this.r, this.g, this.b).getRGB();
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource.BufferSource buffer, double cameraX, double cameraY, double cameraZ) {
        Camera camera = this.getCamera();
        if (camera.isInitialized()) {
            stack.pushPose();
            stack.translate((float)((Double)this.pos.x - cameraX), (float)((Double)this.pos.y - cameraY) + 0.07f, (float)((Double)this.pos.z - cameraZ));
            stack.mulPose((Quaternionfc)camera.rotation());
            stack.scale(this.size, -this.size, this.size);
            float f = this.centered ? (float)(-GuiUtils.getTextSize(this.text)) / 2.0f : 0.0f;
            ClientUtils.getClient().font.drawInBatch(this.text, f -= this.offset / this.size, 0.0f, this.getColor(), this.shadow, stack.last().pose(), (MultiBufferSource)buffer, this.xray ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, 0, 0xF000F0);
            stack.popPose();
        }
    }
}

