/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.layouts.component;

import dev.boxadactle.boxlib.layouts.LayoutComponent;
import dev.boxadactle.boxlib.util.GuiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ParagraphComponent
extends LayoutComponent<List<Component>> {
    int textPadding;

    public ParagraphComponent(int textPadding, Component ... components) {
        super(new ArrayList());
        this.textPadding = textPadding;
        ((List)this.component).addAll(Arrays.asList(components));
    }

    public void add(Component component) {
        ((List)this.component).add(component);
    }

    public void remove(Component component) {
        ((List)this.component).remove(component);
    }

    @Override
    public int getWidth() {
        return GuiUtils.getLongestLength(((List)this.component).toArray(new Component[0]));
    }

    @Override
    public int getHeight() {
        return ((List)this.component).size() * (GuiUtils.getTextHeight() + this.textPadding * 2) - this.textPadding * 2;
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y) {
        int currentY = y;
        for (Component component : (List)this.component) {
            graphics.drawString(GuiUtils.getTextRenderer(), component, x, currentY, 0xFFFFFF);
            currentY += GuiUtils.getTextHeight() + this.textPadding * 2;
        }
    }
}

