/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.geometry;

import dev.boxadactle.boxlib.math.geometry.Vec2;

public class Triangle<T extends Number> {
    public Vec2<T> vertex1;
    public Vec2<T> vertex2;
    public Vec2<T> vertex3;

    public Triangle(Vec2<T> vertex1, Vec2<T> vertex2, Vec2<T> vertex3) {
        this.vertex1 = vertex1;
        this.vertex2 = vertex2;
        this.vertex3 = vertex3;
    }

    public Vec2<T> getVertex1() {
        return this.vertex1;
    }

    public Vec2<T> getVertex2() {
        return this.vertex2;
    }

    public Vec2<T> getVertex3() {
        return this.vertex3;
    }

    public T getPerimeter() {
        double side1 = (Double)this.calculateDistance(this.vertex1, this.vertex2);
        double side2 = (Double)this.calculateDistance(this.vertex2, this.vertex3);
        double side3 = (Double)this.calculateDistance(this.vertex3, this.vertex1);
        return (T)Double.valueOf(side1 + side2 + side3);
    }

    public T getArea() {
        double side1 = (Double)this.calculateDistance(this.vertex1, this.vertex2);
        double side2 = (Double)this.calculateDistance(this.vertex2, this.vertex3);
        double side3 = (Double)this.calculateDistance(this.vertex3, this.vertex1);
        double s = (side1 + side2 + side3) / 2.0;
        return (T)Double.valueOf(Math.sqrt(s * (s - side1) * (s - side2) * (s - side3)));
    }

    public boolean containsPoint(Vec2<T> point) {
        double areaPAB;
        double areaPCA;
        double areaPBC;
        double areaABC = (Double)this.getArea();
        return Math.abs(areaABC - ((areaPBC = ((Double)new Triangle<T>(point, this.vertex2, this.vertex3).getArea()).doubleValue()) + (areaPCA = ((Double)new Triangle<T>(this.vertex1, point, this.vertex3).getArea()).doubleValue()) + (areaPAB = ((Double)new Triangle<T>(this.vertex1, this.vertex2, point).getArea()).doubleValue()))) < 1.0E-9;
    }

    private T calculateDistance(Vec2<T> p1, Vec2<T> p2) {
        double dx = ((Number)p2.getX()).doubleValue() - ((Number)p1.getX()).doubleValue();
        double dy = ((Number)p2.getY()).doubleValue() - ((Number)p1.getY()).doubleValue();
        return (T)Double.valueOf(Math.sqrt(dx * dx + dy * dy));
    }

    protected Triangle<T> clone() {
        return new Triangle<T>(this.vertex1, this.vertex2, this.vertex3);
    }
}

