/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.prompt;

import dev.boxadactle.boxlib.function.Consumer2;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.util.ClientUtils;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public abstract class PromptScreen<T>
extends Screen
implements BOptionHelper {
    Screen parent;
    Consumer2<Boolean, T> dataConsumer;
    Button okButton;

    protected PromptScreen(Screen parent) {
        super((Component)Component.literal((String)"BoxLib prompt screen"));
        this.parent = parent;
    }

    protected abstract T getData();

    protected abstract boolean allowContinue();

    protected boolean hasButtons() {
        return true;
    }

    public void onData(Consumer2<Boolean, T> dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    protected void closeScreen(boolean hasData) {
        ClientUtils.setScreen(this.parent);
        if (this.dataConsumer != null) {
            if (hasData && !this.allowContinue()) {
                hasData = false;
            }
            this.dataConsumer.accept(hasData, (Boolean)(hasData ? (Object)this.getData() : null));
        }
    }

    public void onClose() {
        this.closeScreen(false);
    }

    protected int getStartX() {
        return this.width / 2 - this.getPadding() / 2 - this.getButtonWidth(BOptionHelper.ButtonType.SMALL);
    }

    protected int getStartY() {
        return this.height / 2 + 50;
    }

    protected void init() {
        if (this.hasButtons()) {
            int startX = this.getStartX();
            int startY = this.getStartY();
            this.addRenderableWidget((GuiEventListener)this.createHalfCancelButton(startX, startY, b -> this.closeScreen(false)));
            this.okButton = (Button)this.addRenderableWidget((GuiEventListener)this.createHalfOkButton(startX, startY, b -> this.closeScreen(true)));
        }
    }

    public void tick() {
        if (this.okButton != null) {
            this.okButton.active = this.allowContinue();
        }
    }
}

