/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.rendering.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.boxadactle.boxlib.math.geometry.Box;
import dev.boxadactle.boxlib.rendering.Renderer3D;
import dev.boxadactle.boxlib.rendering.renderers.LineRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.AABB;

public class OutlineRenderer
extends Renderer3D<OutlineRenderer> {
    private LineRenderer[] edges = new LineRenderer[12];

    public OutlineRenderer(boolean disposeNextFrame) {
        super(disposeNextFrame);
    }

    private LineRenderer edge(double x1, double y1, double z1, double x2, double y2, double z2) {
        return new LineRenderer(false).setPos(x1, y1, z1, x2, y2, z2);
    }

    public OutlineRenderer setCube(AABB cube) {
        this.edges[0] = this.edge(cube.minX, cube.minY, cube.minZ, cube.maxX, cube.minY, cube.minZ);
        this.edges[1] = this.edge(cube.minX, cube.minY, cube.minZ, cube.minX, cube.maxY, cube.minZ);
        this.edges[2] = this.edge(cube.minX, cube.minY, cube.minZ, cube.minX, cube.minY, cube.maxZ);
        this.edges[3] = this.edge(cube.maxX, cube.minY, cube.maxX, cube.maxX, cube.minY, cube.minZ);
        this.edges[4] = this.edge(cube.maxX, cube.minY, cube.maxX, cube.maxX, cube.maxY, cube.maxZ);
        this.edges[5] = this.edge(cube.maxX, cube.minY, cube.maxX, cube.minX, cube.minY, cube.maxZ);
        this.edges[6] = this.edge(cube.maxX, cube.maxY, cube.minZ, cube.maxX, cube.minY, cube.minZ);
        this.edges[7] = this.edge(cube.maxX, cube.maxY, cube.minZ, cube.minX, cube.maxY, cube.minZ);
        this.edges[8] = this.edge(cube.maxX, cube.maxY, cube.minZ, cube.maxX, cube.maxY, cube.maxZ);
        this.edges[9] = this.edge(cube.minX, cube.maxY, cube.maxZ, cube.minX, cube.minY, cube.maxZ);
        this.edges[10] = this.edge(cube.minX, cube.maxY, cube.maxZ, cube.minX, cube.maxY, cube.minZ);
        this.edges[11] = this.edge(cube.minX, cube.maxY, cube.maxZ, cube.maxX, cube.maxY, cube.maxZ);
        return this;
    }

    public OutlineRenderer setCube(AABB cube, double expand) {
        AABB inflated = cube.inflate(expand);
        return this.setCube(inflated);
    }

    public OutlineRenderer setCube(Box<Double> cube) {
        return this.setCube(new AABB(cube.minX().doubleValue(), cube.minY().doubleValue(), cube.minZ().doubleValue(), cube.maxX().doubleValue(), cube.maxY().doubleValue(), cube.maxZ().doubleValue()));
    }

    public OutlineRenderer setCube(BlockPos pos) {
        return this.setCube(new AABB(pos));
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource.BufferSource buffer, double cameraX, double cameraY, double cameraZ) {
        for (LineRenderer edge : this.edges) {
            edge.setColor(this.r, this.g, this.b, this.a);
            edge.render(stack, buffer, cameraX, cameraY, cameraZ);
        }
    }
}

