/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import com.mojang.blaze3d.platform.InputConstants;
import dev.boxadactle.boxlib.function.EmptyMethod;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Locale;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.KeyboardHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.ToastManager;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClientUtils {
    public static Minecraft getClient() {
        return Minecraft.getInstance();
    }

    public static Options getOptions() {
        return ClientUtils.getClient().options;
    }

    public static String parseIdentifier(String id) {
        StringBuilder name = new StringBuilder();
        String withoutNamespace = id.split(":")[1];
        String spaces = withoutNamespace.replaceAll("_", " ");
        for (String word : spaces.split("\\s")) {
            String firstLetter = word.substring(0, 1);
            String theRest = word.substring(1);
            name.append(firstLetter.toUpperCase()).append(theRest).append(" ");
        }
        return name.toString().trim();
    }

    public static long getWindow() {
        return ClientUtils.getClient().getWindow().getWindow();
    }

    public static String getGameVersion() {
        return SharedConstants.getCurrentVersion().getName();
    }

    public static KeyboardHandler getKeyboard() {
        return ClientUtils.getClient().keyboardHandler;
    }

    public static Screen getCurrentScreen() {
        return ClientUtils.getClient().screen;
    }

    public static Screen setScreen(Screen newScreen) {
        ClientUtils.getClient().setScreen(newScreen);
        return newScreen;
    }

    @Deprecated
    public static char getTypedKey(int keycode, int scancode) {
        InputConstants.Key a = InputConstants.getKey((int)keycode, (int)scancode);
        String ab = a.getName().substring("key.keyboard.".length());
        if (ab.length() == 1) {
            try {
                int num = Integer.parseInt(ab);
                if (!Screen.hasShiftDown()) {
                    return ab.charAt(0);
                }
                return switch (num) {
                    case 1 -> '!';
                    case 2 -> '@';
                    case 3 -> '#';
                    case 4 -> '$';
                    case 5 -> '%';
                    case 6 -> '^';
                    case 7 -> '&';
                    case 8 -> '*';
                    case 9 -> '(';
                    case 0 -> ')';
                    default -> '\u0000';
                };
            }
            catch (NumberFormatException num) {
                String capitalized = Screen.hasShiftDown() ? ab.toUpperCase(Locale.ROOT) : ab;
                return capitalized.charAt(0);
            }
        }
        boolean b = Screen.hasShiftDown();
        switch (a.getValue()) {
            case 45: {
                if (b) {
                    return '_';
                }
                return '-';
            }
            case 61: {
                if (b) {
                    return '+';
                }
                return '=';
            }
            case 91: {
                if (b) {
                    return '{';
                }
                return '[';
            }
            case 93: {
                if (b) {
                    return '}';
                }
                return ']';
            }
            case 96: {
                if (b) {
                    return '~';
                }
                return '`';
            }
            case 59: {
                if (b) {
                    return ':';
                }
                return ';';
            }
            case 39: {
                if (b) {
                    return '\"';
                }
                return '\'';
            }
            case 44: {
                if (b) {
                    return '<';
                }
                return ',';
            }
            case 46: {
                if (b) {
                    return '>';
                }
                return '.';
            }
            case 32: {
                return ' ';
            }
        }
        return '\u0000';
    }

    public static void openUrl(String url) {
        try {
            URI uri = new URI(url);
            Util.getPlatform().openUri(uri);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed URL: " + url, e);
        }
    }

    public static void openLinkConfirmScreen(String link, Screen parent) {
        ClientUtils.getClient().setScreen((Screen)new ConfirmLinkScreen(open -> {
            if (open) {
                ClientUtils.openUrl(link);
            }
            ClientUtils.setScreen(parent);
        }, link, true));
    }

    public static void confirm(Component message, Component description, EmptyMethod yes, EmptyMethod no) {
        ClientUtils.getClient().setScreen((Screen)new ConfirmScreen(b -> {
            if (b) {
                yes.accept();
            } else {
                no.accept();
            }
        }, message, description));
    }

    public static void showToast(Component message, Component description) {
        SystemToast.addOrUpdate((ToastManager)ClientUtils.getClient().getToastManager(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)message, (Component)description);
    }

    public static Path getConfigFolder() {
        return Path.of(ClientUtils.getClient().gameDirectory.getAbsolutePath() + "/config", new String[0]);
    }
}

