/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import dev.boxadactle.boxlib.math.geometry.Rect;
import dev.boxadactle.boxlib.math.geometry.Vec2;
import dev.boxadactle.boxlib.util.GuiUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class RenderUtils {
    public static void drawSquare(GuiGraphics guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.fill(x, y, x + width, y + height, color);
    }

    public static void drawSquare(GuiGraphics guiGraphics, int x, int y, int width, int height) {
        RenderUtils.drawSquare(guiGraphics, x, y, width, height, 0xFFFFFF);
    }

    public static void drawSquare(GuiGraphics guiGraphics, Rect<Integer> rect, int color) {
        RenderUtils.drawSquare(guiGraphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), color);
    }

    public static void drawSquare(GuiGraphics guiGraphics, Rect<Integer> rect) {
        RenderUtils.drawSquare(guiGraphics, rect, 0xFFFFFF);
    }

    public static void drawTexture(ResourceLocation texture, GuiGraphics guiGraphics, int x, int y, int width, int height, int u, int v) {
        guiGraphics.blit(RenderType::guiTextured, texture, x, y, (float)u, (float)v, width, height, width, height);
    }

    public static void drawTexture(ResourceLocation texture, GuiGraphics guiGraphics, Rect<Integer> rect, int u, int v) {
        RenderUtils.drawTexture(texture, guiGraphics, rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), u, v);
    }

    public static void drawTexture(ResourceLocation texture, GuiGraphics guiGraphics, Rect<Integer> rect, Vec2<Integer> uv) {
        RenderUtils.drawTexture(texture, guiGraphics, rect, uv.getX(), uv.getY());
    }

    public static void drawTexture(ResourceLocation texture, GuiGraphics guiGraphics, int x, int y, int width, int height, Vec2<Integer> uv) {
        RenderUtils.drawTexture(texture, guiGraphics, new Rect<Integer>(x, y, width, height), uv);
    }

    public static void drawText(GuiGraphics guiGraphics, Component text, int x, int y) {
        RenderUtils.drawText(guiGraphics, text, x, y, 0xFFFFFF);
    }

    public static void drawText(GuiGraphics guiGraphics, Component text, int x, int y, int color) {
        guiGraphics.drawString(GuiUtils.getTextRenderer(), text, x, y, color, true);
    }

    public static void drawText(GuiGraphics guiGraphics, String text, int x, int y) {
        RenderUtils.drawText(guiGraphics, text, x, y, 0xFFFFFF);
    }

    public static void drawText(GuiGraphics guiGraphics, String text, int x, int y, int color) {
        guiGraphics.drawString(GuiUtils.getTextRenderer(), text, x, y, color, true);
    }

    public static void drawTextCentered(GuiGraphics guiGraphics, Component text, int x, int y) {
        RenderUtils.drawTextCentered(guiGraphics, text, x, y, 0xFFFFFF);
    }

    public static void drawTextCentered(GuiGraphics guiGraphics, Component text, int x, int y, int color) {
        guiGraphics.drawString(GuiUtils.getTextRenderer(), text, x - GuiUtils.getTextRenderer().width((FormattedText)text) / 2, y, color, true);
    }

    public static void drawTextCentered(GuiGraphics guiGraphics, String text, int x, int y) {
        RenderUtils.drawTextCentered(guiGraphics, text, x, y, 0xFFFFFF);
    }

    public static void drawTextCentered(GuiGraphics guiGraphics, String text, int x, int y, int color) {
        guiGraphics.drawString(GuiUtils.getTextRenderer(), text, x - GuiUtils.getTextRenderer().width(text) / 2, y, color, true);
    }
}

