/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.config;

import dev.boxadactle.boxlib.config.BConfig;
import dev.boxadactle.boxlib.config.BConfigClass;
import dev.boxadactle.boxlib.config.BConfigFile;
import dev.boxadactle.boxlib.util.ClientUtils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Objects;

public class BConfigHandler {
    private static final HashMap<Class<? extends BConfig>, BConfigClass<?>> classes = new HashMap();

    private static String verifyFileExtension(String filename, String extension) {
        Object nExtension = extension.trim().startsWith(".") ? extension : "." + extension;
        return filename + (String)nExtension;
    }

    private static File getPath(String filename, String extension) {
        Path path = Paths.get(ClientUtils.getConfigFolder().toString(), BConfigHandler.verifyFileExtension(filename, extension));
        return new File(path.toString());
    }

    public static <T extends BConfig> BConfigClass<T> registerConfig(Class<T> config) {
        Objects.requireNonNull(config);
        if (classes.containsKey(config)) {
            throw new BConfig.ConfigException("Class " + config.getName() + " has already been registered!");
        }
        BConfigFile a = config.getAnnotation(BConfigFile.class);
        if (a != null) {
            if (a.value().isEmpty()) {
                throw new BConfig.ConfigException("Class " + config.getName() + " does not specify a filename");
            }
        } else {
            throw new BConfig.ConfigException("Class " + config.getName() + " does not annotate the BConfigFile annotation.");
        }
        File filepath = BConfigHandler.getPath(a.value(), a.filetype());
        BConfigClass<T> holder = new BConfigClass<T>(config, filepath);
        holder.load();
        classes.put(config, holder);
        return holder;
    }

    public static <T extends BConfig> BConfigClass<T> getConfigClass(Class<T> config) {
        return classes.get(config);
    }
}

