/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui;

import dev.boxadactle.boxlib.function.Function2;
import dev.boxadactle.boxlib.gui.config.BConfigList;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.button.BCustomButton;
import dev.boxadactle.boxlib.gui.config.widget.field.BStringField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class ConfigGuiBuilder {
    public static Builder builder(class_437 parent, class_2561 name) {
        return new Builder(parent, name);
    }

    public static Builder builder(class_2561 name) {
        return new Builder(null, name);
    }

    public static class Builder {
        class_2561 name;
        class_437 parent;
        List<BConfigList.ConfigEntry> entries = new ArrayList<BConfigList.ConfigEntry>();
        Function2<class_8667, class_437, class_4185> footerProvider;

        public Builder(class_437 parent, class_2561 name) {
            this.parent = parent;
            this.name = name;
        }

        public Builder addEntry(BOptionEntry<?> entry) {
            this.entries.add(new BConfigList.SingleEntry(entry));
            return this;
        }

        public Builder addCustomEntry(BConfigList.ConfigEntry entry) {
            this.entries.add(entry);
            return this;
        }

        public Builder addDoubleEntry(BOptionEntry<?> entry1, BOptionEntry<?> entry2) {
            this.entries.add(new BConfigList.DoubleEntry(entry1, entry2));
            return this;
        }

        public Builder addButton(class_2561 message, Runnable onClick) {
            this.entries.add(new BConfigList.SingleEntry(BCustomButton.create(message, onClick)));
            return this;
        }

        public Builder addLabel(class_2561 message) {
            this.entries.add(new BConfigList.SingleEntry(new BCenteredLabel(message)));
            return this;
        }

        public Builder addInput(String value, Consumer<String> consumer) {
            this.entries.add(new BConfigList.SingleEntry(new BStringField(value, consumer)));
            return this;
        }

        public Builder setFooterProvider(Function2<class_8667, class_437, class_4185> footerProvider) {
            this.footerProvider = footerProvider;
            return this;
        }

        public Builder setFooterProvider(Function<class_437, class_4185> footerProvider) {
            return this.setFooterProvider((class_8667 layout, class_437 screen) -> (class_4185)layout.method_52736((class_8021)((class_4185)footerProvider.apply((class_437)screen))));
        }

        public BOptionScreen build() {
            return new BOptionScreen(this.parent, this.name){

                @Override
                protected void initFooter(class_8667 layout) {
                    if (footerProvider != null) {
                        footerProvider.accept(layout, this.parent);
                    } else {
                        layout.method_52736((class_8021)this.createDoneButton(this.parent));
                    }
                }

                protected void method_60325() {
                    entries.forEach(x$0 -> this.addConfigLine(x$0));
                }
            };
        }
    }
}

