/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.math.geometry;

public class Circle<T extends Number> {
    public T radius;

    public Circle(T radius) {
        this.radius = radius;
    }

    public T getRadius() {
        return this.radius;
    }

    public T getArea() {
        double radiusValue = ((Number)this.radius).doubleValue();
        return (T)Double.valueOf(Math.PI * radiusValue * radiusValue);
    }

    public T getCircumference() {
        return (T)Double.valueOf(Math.PI * 2 * ((Number)this.radius).doubleValue());
    }

    public boolean intersects(Circle<T> otherCircle) {
        double combinedRadii;
        double distanceBetweenCenters = (Double)this.calculateDistance(this, otherCircle);
        return distanceBetweenCenters <= (combinedRadii = ((Number)this.radius).doubleValue() + ((Number)otherCircle.getRadius()).doubleValue());
    }

    private T calculateDistance(Circle<T> circle1, Circle<T> circle2) {
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = ((Number)circle2.getRadius()).doubleValue();
        double y2 = 0.0;
        return (T)Double.valueOf(Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)));
    }

    protected Circle<T> clone() {
        return new Circle<T>(this.radius);
    }
}

