/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.test;

import com.mojang.brigadier.Command;
import dev.boxadactle.boxlib.command.BCommandManager;
import dev.boxadactle.boxlib.command.BCommandSourceStack;
import dev.boxadactle.boxlib.command.api.BCommand;
import dev.boxadactle.boxlib.command.api.subcommand.BLabelSubcommand;
import dev.boxadactle.boxlib.command.api.subcommand.BasicSubcommand;
import dev.boxadactle.boxlib.command.api.subcommand.BooleanSubcommand;
import dev.boxadactle.boxlib.command.api.subcommand.DoubleSubcommand;
import dev.boxadactle.boxlib.command.api.subcommand.FloatSubcommand;
import dev.boxadactle.boxlib.command.api.subcommand.StringSubcommand;
import dev.boxadactle.boxlib.config.BConfigClass;
import dev.boxadactle.boxlib.config.BConfigHandler;
import dev.boxadactle.boxlib.keybind.KeybindHelper;
import dev.boxadactle.boxlib.math.geometry.Box;
import dev.boxadactle.boxlib.math.geometry.Vec3;
import dev.boxadactle.boxlib.rendering.RenderQueue;
import dev.boxadactle.boxlib.rendering.renderers.BoxRenderer;
import dev.boxadactle.boxlib.rendering.renderers.OutlineRenderer;
import dev.boxadactle.boxlib.rendering.renderers.PathRenderer;
import dev.boxadactle.boxlib.rendering.renderers.TextRenderer;
import dev.boxadactle.boxlib.test.config.ExampleConfigClass;
import dev.boxadactle.boxlib.test.config.ExampleConfigClass2;
import dev.boxadactle.boxlib.test.keybind.Keybindings;
import dev.boxadactle.boxlib.translate.Language;
import dev.boxadactle.boxlib.translate.Translator;
import dev.boxadactle.boxlib.util.GuiUtils;
import dev.boxadactle.boxlib.util.ModLogger;
import dev.boxadactle.boxlib.util.WorldUtils;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import oshi.util.tuples.Pair;

public class TestMod {
    public static final String MOD_NAME = "Boxlib Test Mod";
    public static final ModLogger LOGGER = new ModLogger("Boxlib Test Mod");
    public static BConfigClass<ExampleConfigClass> CONFIG;
    public static BConfigClass<ExampleConfigClass2> CONFIG2;

    public static void init() {
        LOGGER.info("Initializing Boxlib Test Mod...", new Object[0]);
        CONFIG = BConfigHandler.registerConfig(ExampleConfigClass.class);
        CONFIG2 = BConfigHandler.registerConfig(ExampleConfigClass2.class);
        BCommandManager.register(BCommand.create("funny", context -> {
            TestMod.LOGGER.player.info("You are funny!", new Object[0]);
            return 0;
        }).registerSubcommand(new BasicSubcommand("not", (Command<BCommandSourceStack>)((Command)context -> {
            TestMod.LOGGER.player.info("You are not funny!", new Object[0]);
            return 0;
        })).registerSubcommand(new BasicSubcommand("sike", (Command<BCommandSourceStack>)((Command)context -> {
            TestMod.LOGGER.player.info("Sike! You are funny!", new Object[0]);
            return 0;
        })))).registerSubcommand(new BLabelSubcommand("adverb", (Command<BCommandSourceStack>)((Command)context -> {
            TestMod.LOGGER.player.info("You did not specify an adverb!", new Object[0]);
            return 0;
        }), new StringSubcommand("adverb", (context, string) -> {
            TestMod.LOGGER.player.info("You are " + string + " funny!", new Object[0]);
            return 0;
        }))).registerSubcommand(new BLabelSubcommand("boolean", new BooleanSubcommand("bool", (context, bool) -> {
            TestMod.LOGGER.player.info("You said " + (bool != false ? "yes!" : "no :("), new Object[0]);
            return 0;
        }))).registerSubcommand(new BLabelSubcommand("double", new DoubleSubcommand("double", (context, d) -> {
            TestMod.LOGGER.player.info("An atom is " + d + " (double) millimeters large", new Object[0]);
            return 0;
        }))).registerSubcommand(new BLabelSubcommand("float", new FloatSubcommand("float", (context, f) -> {
            TestMod.LOGGER.player.info("New years eve was " + f + " seconds ago", new Object[0]);
            return 0;
        }))).registerSubcommand(new BLabelSubcommand("integer", new DoubleSubcommand("int", (context, i) -> {
            TestMod.LOGGER.player.info("You have read " + i + " books", new Object[0]);
            return 0;
        }))).registerSubcommand(new BLabelSubcommand("long", new DoubleSubcommand("long", (context, l) -> {
            TestMod.LOGGER.player.info("The universe has existed for " + l + " years", new Object[0]);
            return 0;
        }))));
        Keybindings.init();
        String message = "Test keybind 1 is bound to " + String.valueOf(KeybindHelper.getBoundKey(Keybindings.TEST_KEYBIND));
        String translated = Translator.translate(message, Language.SPANISH);
        LOGGER.info(translated, new Object[0]);
        TextRenderer renderer = ((TextRenderer)new TextRenderer(false).setPos(new Vec3<Double>(0.0, 100.0, 0.0)).setText((class_2561)class_2561.method_43470((String)"Hello, world!")).setSize(0.3f).setColor(GuiUtils.BLUE)).setCentered(true).setXray(false);
        OutlineRenderer outlineRenderer = (OutlineRenderer)((OutlineRenderer)new OutlineRenderer(false).setCube(new Box<Double>(-1.0, 105.0, -1.0, 1.0, 2.0, 1.0)).setColor(GuiUtils.YELLOW)).setAlpha(0.5f);
        PathRenderer pathRenderer = (PathRenderer)new PathRenderer(false).setPoints(new Vec3<Double>(-1.0, 100.0, -1.0), new Vec3<Double>(1.0, 103.0, -1.0), new Vec3<Double>(1.0, 107.0, 1.0), new Vec3<Double>(-1.0, 112.0, 1.0), new Vec3<Double>(-1.0, 114.0, -1.0)).setColor(GuiUtils.RED);
        BoxRenderer boxRenderer = (BoxRenderer)((BoxRenderer)new BoxRenderer(false).setCube(new class_2338(10, 100, 0)).setColor(GuiUtils.GOLD)).setAlpha(0.3f);
        RenderQueue.addRenderer(renderer);
        RenderQueue.addRenderer(outlineRenderer);
        RenderQueue.addRenderer(pathRenderer);
        RenderQueue.addRenderer(boxRenderer);
        RenderQueue.addRenderer(() -> {
            class_243 playerPos = WorldUtils.getCamera().method_73189().method_1031(10.0, 0.0, 0.0);
            BoxRenderer awayRenderer = (BoxRenderer)((BoxRenderer)new BoxRenderer(false).setCube(new class_238(new class_2338((int)playerPos.field_1352, (int)playerPos.field_1351, (int)playerPos.field_1350))).setColor(GuiUtils.GOLD)).setAlpha(0.3f);
            return new Pair((Object)awayRenderer, (Object)true);
        });
        RenderQueue.addRenderer(() -> {
            class_243 playerPos = WorldUtils.getCamera().method_73189();
            TextRenderer north = ((TextRenderer)new TextRenderer(false).setPos(new Vec3<Double>(playerPos.field_1352, playerPos.field_1351 + 1.0, playerPos.field_1350 - 10.0)).setText((class_2561)class_2561.method_43470((String)"N")).setSize(0.3f).setColor(GuiUtils.RED)).setCentered(true).setXray(true);
            return new Pair((Object)north, (Object)true);
        });
        RenderQueue.addRenderer(() -> {
            class_243 playerPos = WorldUtils.getCamera().method_73189();
            TextRenderer east = ((TextRenderer)new TextRenderer(false).setPos(new Vec3<Double>(playerPos.field_1352 + 10.0, playerPos.field_1351 + 1.0, playerPos.field_1350)).setText((class_2561)class_2561.method_43470((String)"E")).setSize(0.3f).setColor(GuiUtils.GREEN)).setCentered(true).setXray(true);
            return new Pair((Object)east, (Object)true);
        });
        RenderQueue.addRenderer(() -> {
            class_243 playerPos = WorldUtils.getCamera().method_73189();
            TextRenderer south = ((TextRenderer)new TextRenderer(false).setPos(new Vec3<Double>(playerPos.field_1352, playerPos.field_1351 + 1.0, playerPos.field_1350 + 10.0)).setText((class_2561)class_2561.method_43470((String)"S")).setSize(0.3f).setColor(GuiUtils.BLUE)).setCentered(true).setXray(true);
            return new Pair((Object)south, (Object)true);
        });
        RenderQueue.addRenderer(() -> {
            class_243 playerPos = WorldUtils.getCamera().method_73189();
            TextRenderer west = ((TextRenderer)new TextRenderer(false).setPos(new Vec3<Double>(playerPos.field_1352 - 10.0, playerPos.field_1351 + 1.0, playerPos.field_1350)).setText((class_2561)class_2561.method_43470((String)"W")).setSize(0.3f).setColor(GuiUtils.YELLOW)).setCentered(true).setXray(true);
            return new Pair((Object)west, (Object)true);
        });
    }
}

