/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import dev.boxadactle.boxlib.util.ClientUtils;
import dev.boxadactle.boxlib.util.GuiUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_338;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLogger {
    private final Logger logger;
    private final String prefix;
    private final class_2561 chatPrefix;
    private final class_310 client;
    public PlayerLogging player;

    public ModLogger(String modName) {
        this.logger = LogManager.getFormatterLogger((String)modName);
        this.client = ClientUtils.getClient();
        this.prefix = "[" + modName + "]: ";
        this.chatPrefix = GuiUtils.colorize(GuiUtils.brackets(GuiUtils.colorize((class_2561)class_2561.method_43470((String)modName), GuiUtils.AQUA)), GuiUtils.BLUE);
        this.player = new PlayerLogging(this.client, modName);
    }

    public void error(Object msg, Object ... data) {
        this.logger.log(Level.ERROR, this.prefix + String.valueOf(msg), data);
    }

    public void warn(Object msg, Object ... data) {
        this.logger.log(Level.WARN, this.prefix + String.valueOf(msg), data);
    }

    public void info(Object msg, Object ... data) {
        this.logger.log(Level.INFO, this.prefix + String.valueOf(msg), data);
    }

    public void debug(Object msg, Object ... data) {
        this.logger.log(Level.DEBUG, this.prefix + String.valueOf(msg), data);
    }

    public void printStackTrace(Exception e) {
        StackTraceElement[] stacktrace = e.getStackTrace();
        this.logger.error(this.prefix + e.getMessage());
        for (StackTraceElement stackTraceElement : stacktrace) {
            this.logger.error(this.prefix + "\t" + stackTraceElement.toString());
        }
    }

    public class_2561 getChatPrefix() {
        return this.chatPrefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static class PlayerLogging {
        private final class_2561 prefix;
        private final class_310 client;

        public PlayerLogging(class_310 client, String prefix) {
            this.client = client;
            this.prefix = GuiUtils.colorize(GuiUtils.brackets(GuiUtils.colorize((class_2561)class_2561.method_43470((String)prefix), 0x55FFFF)), 43690).method_27661().method_27693(" ");
        }

        public void error(String msg, Object ... data) {
            if (this.client.field_1724 != null) {
                class_338 chat = ClientUtils.getClient().field_1705.method_1743();
                chat.method_1812((class_2561)this.prefix.method_27661().method_10852(GuiUtils.colorize((class_2561)class_2561.method_43470((String)String.format(msg, data)), GuiUtils.RED)));
            }
        }

        public void warn(String msg, Object ... data) {
            if (this.client.field_1724 != null) {
                class_338 chat = ClientUtils.getClient().field_1705.method_1743();
                chat.method_1812((class_2561)this.prefix.method_27661().method_10852(GuiUtils.colorize((class_2561)class_2561.method_43470((String)String.format(msg, data)), GuiUtils.YELLOW)));
            }
        }

        public void info(String msg, Object ... data) {
            if (this.client.field_1724 != null) {
                class_338 chat = ClientUtils.getClient().field_1705.method_1743();
                chat.method_1812((class_2561)this.prefix.method_27661().method_10852((class_2561)class_2561.method_43470((String)String.format(msg, data))));
            }
        }

        public void chat(class_2561 msg) {
            if (this.client.field_1724 != null) {
                class_338 chat = ClientUtils.getClient().field_1705.method_1743();
                chat.method_1812((class_2561)this.prefix.method_27661().method_10852(msg));
            }
        }

        public void publicChat(String msg) {
            if (this.client.field_1724 != null) {
                this.client.field_1724.field_3944.method_45729(msg);
            }
        }
    }
}

