/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.gui.auto;

import dev.boxadactle.boxlib.core.BoxLib;
import dev.boxadactle.boxlib.function.Function2;
import dev.boxadactle.boxlib.function.Function5;
import dev.boxadactle.boxlib.function.Function6;
import dev.boxadactle.boxlib.gui.auto.Color;
import dev.boxadactle.boxlib.gui.auto.CustomText;
import dev.boxadactle.boxlib.gui.auto.Gui;
import dev.boxadactle.boxlib.gui.auto.HideValue;
import dev.boxadactle.boxlib.gui.auto.Slider;
import dev.boxadactle.boxlib.gui.auto.Tooltip;
import dev.boxadactle.boxlib.gui.config.BOptionEntry;
import dev.boxadactle.boxlib.gui.config.BOptionHelper;
import dev.boxadactle.boxlib.gui.config.BOptionScreen;
import dev.boxadactle.boxlib.gui.config.widget.button.BBooleanButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BColorPickerButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BEnumButton;
import dev.boxadactle.boxlib.gui.config.widget.button.BScreenButton;
import dev.boxadactle.boxlib.gui.config.widget.field.BArgbField;
import dev.boxadactle.boxlib.gui.config.widget.field.BDoubleField;
import dev.boxadactle.boxlib.gui.config.widget.field.BFloatField;
import dev.boxadactle.boxlib.gui.config.widget.field.BIntegerField;
import dev.boxadactle.boxlib.gui.config.widget.field.BLongField;
import dev.boxadactle.boxlib.gui.config.widget.field.BShortField;
import dev.boxadactle.boxlib.gui.config.widget.field.BStringField;
import dev.boxadactle.boxlib.gui.config.widget.label.BCenteredLabel;
import dev.boxadactle.boxlib.gui.config.widget.slider.BDoubleSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BFloatSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BIntegerSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BLongSlider;
import dev.boxadactle.boxlib.gui.config.widget.slider.BShortSlider;
import dev.boxadactle.boxlib.util.GuiUtils;
import java.lang.reflect.Field;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class AutoConfigGui {
    public static AutoConfigGuiBuilder start(Object config, class_437 parent) {
        return new AutoConfigGuiBuilder(config, parent);
    }

    public static class AutoConfigGuiBuilder
    implements BOptionHelper {
        Object config;
        class_437 parent;
        Function2<class_8667, class_437, class_4185> footerProvider;

        protected AutoConfigGuiBuilder(Object config, class_437 parent) {
            this.config = config;
            this.parent = parent;
            this.setFooterProvider(this::createDoneButton);
        }

        public AutoConfigGuiBuilder parent(class_437 parent) {
            this.parent = parent;
            return this;
        }

        public AutoConfigGuiBuilder setFooterProvider(Function2<class_8667, class_437, class_4185> footerProvider) {
            this.footerProvider = footerProvider;
            return this;
        }

        public AutoConfigGuiBuilder setFooterProvider(Function<class_437, class_4185> footerProvider) {
            return this.setFooterProvider((class_8667 layout, class_437 screen) -> (class_4185)layout.method_52736((class_8021)((class_4185)footerProvider.apply((class_437)screen))));
        }

        private String getKey(Field field) {
            if (field.isAnnotationPresent(CustomText.class)) {
                CustomText customKey = field.getAnnotation(CustomText.class);
                return customKey.value();
            }
            return "boxlib.autoconfig." + field.getName();
        }

        private class_7919 getTooltip(Field field) {
            if (field.isAnnotationPresent(Tooltip.class)) {
                Tooltip tooltip = field.getAnnotation(Tooltip.class);
                return class_7919.method_47407((class_2561)(tooltip.translate() ? class_2561.method_43471((String)tooltip.value()) : class_2561.method_43470((String)tooltip.value())));
            }
            return null;
        }

        private void intOption(Field field, Object config, Function<BOptionEntry<?>, BOptionEntry<?>> consumer, class_437 thisScreen) throws IllegalAccessException {
            boolean bl = field.isAnnotationPresent(Color.class);
            if (field.isAnnotationPresent(Slider.class)) {
                Slider slider = field.getAnnotation(Slider.class);
                if (bl) {
                    Color color = field.getAnnotation(Color.class);
                    consumer.apply(new BColorPickerButton(this.getKey(field), thisScreen, color.value(), field.getInt(config), v -> {
                        try {
                            field.set(config, v);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    })).tooltip(this.getTooltip(field));
                } else {
                    consumer.apply(new BIntegerSlider(this.getKey(field), (int)Math.round(slider.min()), (int)Math.round(slider.max()), field.getInt(config), v -> {
                        try {
                            field.set(config, v);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    })).tooltip(this.getTooltip(field));
                }
            } else {
                consumer.apply(new BCenteredLabel((class_2561)class_2561.method_43471((String)this.getKey(field))));
                if (bl) {
                    consumer.apply(new BArgbField(field.getInt(config), v -> {
                        try {
                            field.set(config, v);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    })).tooltip(this.getTooltip(field));
                } else {
                    consumer.apply(new BIntegerField(field.getInt(config), v -> {
                        try {
                            field.set(config, v);
                        }
                        catch (IllegalAccessException e) {
                            throw new RuntimeException(e);
                        }
                    })).tooltip(this.getTooltip(field));
                }
            }
        }

        private void boolOption(Field field, Object config, Function<BOptionEntry<?>, BOptionEntry<?>> consumer) throws IllegalAccessException {
            consumer.apply(new BBooleanButton(this.getKey(field), field.getBoolean(config), v -> {
                try {
                    field.set(config, v);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            })).tooltip(this.getTooltip(field));
        }

        private <T extends Number> void fieldOption(Field field, Object config, Function<BOptionEntry<?>, BOptionEntry<?>> consumer, Function2<T, Consumer<T>, BOptionEntry<?>> fieldConstructor, Function6<String, T, T, T, Integer, Consumer<T>, BOptionEntry<?>> sliderConstructor, Function<Double, T> converter) throws IllegalAccessException {
            if (field.isAnnotationPresent(Slider.class)) {
                Slider slider = field.getAnnotation(Slider.class);
                consumer.apply(sliderConstructor.accept(this.getKey(field), (String)((Object)((Number)converter.apply(slider.min()))), (String)((Object)((Number)converter.apply(slider.max()))), (String)((Object)((Number)field.get(config))), slider.decimalPlaces(), (Consumer<String>)((Consumer<Number>)v -> {
                    try {
                        field.set(config, v);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }))).tooltip(this.getTooltip(field));
            } else {
                consumer.apply(new BCenteredLabel((class_2561)class_2561.method_43471((String)this.getKey(field))));
                consumer.apply(fieldConstructor.accept((Number)field.get(config), v -> {
                    try {
                        field.set(config, v);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                })).tooltip(this.getTooltip(field));
            }
        }

        private <T extends Number> void fieldOption(Field field, Object config, Function<BOptionEntry<?>, BOptionEntry<?>> consumer, Function2<T, Consumer<T>, BOptionEntry<?>> fieldConstructor, Function5<String, T, T, T, Consumer<T>, BOptionEntry<?>> sliderConstructor, Function<Double, T> converter) throws IllegalAccessException {
            this.fieldOption(field, config, consumer, fieldConstructor, (String key, T min, T max, T value, Integer ignored, Consumer<T> cons) -> (BOptionEntry)sliderConstructor.accept((String)key, (Object)min, (Object)max, (Object)value, (Consumer)cons), converter);
        }

        private void stringOption(Field field, Object config, Function<BOptionEntry<?>, BOptionEntry<?>> consumer) throws IllegalAccessException {
            consumer.apply(new BCenteredLabel((class_2561)class_2561.method_43471((String)this.getKey(field))));
            consumer.apply(new BStringField((String)field.get(config), v -> {
                try {
                    field.set(config, v);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            })).tooltip(this.getTooltip(field));
        }

        private void enumOption(Field field, Object config, Function<BOptionEntry<?>, BOptionEntry<?>> consumer) throws IllegalAccessException {
            if (!field.getType().isEnum()) {
                throw new IllegalArgumentException("Field " + field.getName() + " is not an enum type.");
            }
            consumer.apply(new BEnumButton<Enum>(this.getKey(field), (Enum)field.get(config), field.getType(), v -> {
                try {
                    field.set(config, v);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }, GuiUtils.BLUE)).tooltip(this.getTooltip(field));
        }

        private void customOption(Field field, Object config, Function<BOptionEntry<?>, BOptionEntry<?>> consumer, class_437 thisScreen) throws IllegalAccessException {
            if (field.getType().isAnnotationPresent(Gui.class)) {
                consumer.apply(new BScreenButton((class_2561)class_2561.method_43471((String)this.getKey(field)), thisScreen, lastScreen -> AutoConfigGui.start(field.get(config), lastScreen).setFooterProvider(this::createBackButton).build())).tooltip(this.getTooltip(field));
                return;
            }
            if (field.getType().isEnum()) {
                this.enumOption(field, config, consumer);
                return;
            }
            BoxLib.LOGGER.error("Unsupported field type {} in config class {}. Field: {}", field.getType().getSimpleName(), config.getClass().getName(), field.getName());
        }

        public BOptionScreen build() {
            Gui guiMetadata = this.config.getClass().getAnnotation(Gui.class);
            if (guiMetadata == null) {
                throw new IllegalStateException("Config class " + this.config.getClass().getName() + " does not have a @Gui annotation.");
            }
            return new BOptionScreen(this.parent, (class_2561)(guiMetadata.translate() ? class_2561.method_43471((String)guiMetadata.value()) : class_2561.method_43470((String)guiMetadata.value()))){

                @Override
                protected void initFooter(class_8667 layout) {
                    footerProvider.accept(layout, this.field_21335);
                }

                protected void method_60325() {
                    try {
                        for (Field field : config.getClass().getDeclaredFields()) {
                            if (field.isAnnotationPresent(HideValue.class)) continue;
                            field.setAccessible(true);
                            switch (field.getType().getSimpleName()) {
                                case "int": 
                                case "Integer": {
                                    this.intOption(field, config, x$0 -> this.addConfigLine(x$0), (class_437)this);
                                    break;
                                }
                                case "boolean": 
                                case "Boolean": {
                                    this.boolOption(field, config, x$0 -> this.addConfigLine(x$0));
                                    break;
                                }
                                case "double": 
                                case "Double": {
                                    this.fieldOption(field, config, x$0 -> this.addConfigLine(x$0), BDoubleField::new, BDoubleSlider::new, Double::valueOf);
                                    break;
                                }
                                case "float": 
                                case "Float": {
                                    this.fieldOption(field, config, x$0 -> this.addConfigLine(x$0), BFloatField::new, BFloatSlider::new, Double::floatValue);
                                    break;
                                }
                                case "long": 
                                case "Long": {
                                    this.fieldOption(field, config, x$0 -> this.addConfigLine(x$0), BLongField::new, BLongSlider::new, Double::longValue);
                                    break;
                                }
                                case "short": 
                                case "Short": {
                                    this.fieldOption(field, config, x$0 -> this.addConfigLine(x$0), BShortField::new, BShortSlider::new, Double::shortValue);
                                    break;
                                }
                                case "String": {
                                    this.stringOption(field, config, x$0 -> this.addConfigLine(x$0));
                                    break;
                                }
                                default: {
                                    this.customOption(field, config, x$0 -> this.addConfigLine(x$0), (class_437)this);
                                }
                            }
                            BoxLib.LOGGER.info(field.getType().getSimpleName(), new Object[0]);
                        }
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Failed to access field in config class " + config.getClass().getName(), e);
                    }
                }
            };
        }
    }
}

