/*
 * Decompiled with CFR 0.152.
 */
package dev.boxadactle.boxlib.util;

import dev.boxadactle.boxlib.util.ClientUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_5348;

public class GuiUtils {
    public static final int AUTO = -1;
    public static final int BLACK = GuiUtils.applyAlpha(0, 1.0f);
    public static final int DARK_BLUE = GuiUtils.applyAlpha(170, 1.0f);
    public static final int DARK_GREEN = GuiUtils.applyAlpha(43520, 1.0f);
    public static final int DARK_AQUA = GuiUtils.applyAlpha(43690, 1.0f);
    public static final int DARK_RED = GuiUtils.applyAlpha(0xAA0000, 1.0f);
    public static final int DARK_PURPLE = GuiUtils.applyAlpha(0xAA00AA, 1.0f);
    public static final int GOLD = GuiUtils.applyAlpha(0xFFAA00, 1.0f);
    public static final int GRAY = GuiUtils.applyAlpha(0xAAAAAA, 1.0f);
    public static final int DARK_GRAY = GuiUtils.applyAlpha(0x555555, 1.0f);
    public static final int BLUE = GuiUtils.applyAlpha(0x5555FF, 1.0f);
    public static final int GREEN = GuiUtils.applyAlpha(0x55FF55, 1.0f);
    public static final int AQUA = GuiUtils.applyAlpha(0x55FFFF, 1.0f);
    public static final int RED = GuiUtils.applyAlpha(0xFF5555, 1.0f);
    public static final int LIGHT_PURPLE = GuiUtils.applyAlpha(0xFF55FF, 1.0f);
    public static final int YELLOW = GuiUtils.applyAlpha(0xFFFF55, 1.0f);
    public static final int WHITE = GuiUtils.applyAlpha(0xFFFFFF, 1.0f);
    public static class_2561 ON;
    public static class_2561 OFF;
    public static class_2561 DONE;
    public static class_2561 CANCEL;
    public static class_2561 YES;
    public static class_2561 NO;
    public static class_2561 OK;
    public static class_2561 ALL;
    public static class_2561 BACK;
    public static class_2561 SAVE;
    public static class_2561 LOAD;
    public static class_2561 REFRESH;
    public static class_2561 ACCEPT;
    public static class_2561 REJECT;
    public static class_2561 ERROR_OCCURED;
    public static class_2561 TRUE;
    public static class_2561 FALSE;

    public static void init() {
        ON = class_2561.method_43471((String)"options.on");
        OFF = class_2561.method_43471((String)"options.off");
        DONE = class_2561.method_43471((String)"gui.done");
        CANCEL = class_2561.method_43471((String)"gui.cancel");
        YES = class_2561.method_43471((String)"gui.yes");
        NO = class_2561.method_43471((String)"gui.no");
        OK = class_2561.method_43471((String)"gui.ok");
        ALL = class_2561.method_43471((String)"gui.all");
        BACK = class_2561.method_43471((String)"gui.back");
        SAVE = class_2561.method_43471((String)"structure_block.mode.save");
        LOAD = class_2561.method_43471((String)"structure_block.mode.load");
        REFRESH = class_2561.method_43471((String)"selectServer.refresh");
        ACCEPT = class_2561.method_43471((String)"mco.invites.button.accept");
        REJECT = class_2561.method_43471((String)"mco.invites.button.reject");
        ERROR_OCCURED = class_2561.method_43471((String)"selectWorld.futureworld.error.title");
        TRUE = GuiUtils.colorize(YES, GREEN);
        FALSE = GuiUtils.colorize(NO, RED);
    }

    public static String getTranslatable(String key) {
        return class_2477.method_10517().method_48307(key);
    }

    public static class_2561 colorize(class_2561 text, int color) {
        return text.method_27661().method_27694(style -> style.method_36139(color));
    }

    @Deprecated
    public static int getColorDecimal(String color) {
        String c;
        return switch (c = color.toLowerCase(Locale.ROOT)) {
            case "dark_red" -> DARK_RED;
            case "red" -> RED;
            case "gold" -> GOLD;
            case "yellow" -> YELLOW;
            case "dark_green" -> DARK_GREEN;
            case "green" -> GREEN;
            case "aqua" -> AQUA;
            case "dark_aqua" -> DARK_AQUA;
            case "dark_blue" -> DARK_BLUE;
            case "blue" -> BLUE;
            case "light_purple" -> LIGHT_PURPLE;
            case "dark_purple" -> DARK_PURPLE;
            case "white" -> WHITE;
            case "gray" -> GRAY;
            case "dark_gray" -> DARK_GRAY;
            case "black" -> BLACK;
            default -> WHITE;
        };
    }

    public static int applyAlpha(int color, float alpha) {
        int a = (int)(alpha * 255.0f);
        return color & 0xFFFFFF | a << 24;
    }

    public static int getTextSize(class_2561 text) {
        return GuiUtils.getTextRenderer().method_27525((class_5348)text);
    }

    public static int getTextHeight() {
        Objects.requireNonNull(ClientUtils.getClient().field_1772);
        return 9;
    }

    public static int getLongestLength(class_2561 ... text) {
        int largest = 0;
        class_327 textRenderer = GuiUtils.getTextRenderer();
        for (class_2561 value : text) {
            int t = textRenderer.method_27525((class_5348)value);
            if (t <= largest) continue;
            largest = t;
        }
        return largest;
    }

    public static int getShortestLength(class_2561 ... text) {
        int shortest = 0;
        class_327 textRenderer = GuiUtils.getTextRenderer();
        shortest = textRenderer.method_27525((class_5348)text[0]);
        for (class_2561 value : text) {
            int t = textRenderer.method_27525((class_5348)value);
            if (t >= shortest) continue;
            shortest = t;
        }
        return shortest;
    }

    public static int getLongestWidget(class_339 ... widgets) {
        int longest = 0;
        for (class_339 widget : widgets) {
            int t = widget.method_25368();
            if (t <= longest) continue;
            longest = t;
        }
        return longest;
    }

    public static class_2561 createHyperLink(class_2561 text, String link) {
        return text.method_27661().method_27695(new class_124[]{class_124.field_1073, class_124.field_1078}).method_27694(a1 -> {
            try {
                return a1.method_10958((class_2558)new class_2558.class_10608(new URI(link))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"chat.link.open")));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static int getTallestWidget(class_339 ... widgets) {
        int tallest = 0;
        for (class_339 widget : widgets) {
            int t = widget.method_25364();
            if (t <= tallest) continue;
            tallest = t;
        }
        return tallest;
    }

    public static int nonZeroGuiScale() {
        int scale = (Integer)ClientUtils.getOptions().method_42474().method_41753();
        class_310 client = ClientUtils.getClient();
        if (scale == 0) {
            return (int)Math.max(1.0, Math.min(Math.floor(client.method_22683().method_4486() / 320), Math.floor(client.method_22683().method_4502() / 240)));
        }
        return scale;
    }

    public static class_2561 surround(String str1, String str2, class_2561 input) {
        return class_2561.method_43470((String)str1).method_10852(input).method_10852((class_2561)class_2561.method_43470((String)str2));
    }

    public static class_2561 parentheses(class_2561 input) {
        return GuiUtils.surround("(", ")", input);
    }

    public static class_2561 brackets(class_2561 input) {
        return GuiUtils.surround("[", "]", input);
    }

    public static class_2561 quotes(class_2561 input) {
        return GuiUtils.surround("\"", "\"", input);
    }

    public static class_327 getTextRenderer() {
        return ClientUtils.getClient().field_1772;
    }
}

