/*
 * Decompiled with CFR 0.152.
 */
package me.superneon4ik.selectiveglowing;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.superneon4ik.selectiveglowing.enums.EntityData;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2739;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class SelectiveGlowing
implements ModInitializer {
    private static final Map<Integer, List<Integer>> GLOWING_MAP = new HashMap<Integer, List<Integer>>();
    private static final class_2940<Byte> FLAGS = SelectiveGlowing.getByteTrackedData();
    private static MinecraftServer minecraftServer = null;
    public static final String MOD_ID = "selectiveglowing";
    public static String VERSION = "unknown";

    public void onInitialize() {
        VERSION = FabricLoader.getInstance().getModContainer(MOD_ID).map(c -> c.getMetadata().getVersion().getFriendlyString()).orElse("unknown");
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            minecraftServer = server;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"glow").requires(source -> source.method_9259(4))).executes(context -> {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_54663(0xFFADFA).method_10852((class_2561)class_2561.method_43470((String)"Selective Glowing ver. %s".formatted(VERSION)).method_27692(class_124.field_1067)).method_10852((class_2561)class_2561.method_43470((String)"\nUsage:\n").method_27692(class_124.field_1056)).method_10852((class_2561)class_2561.method_43470((String)"/glow <targets: entities> <displayplayers: players>\n/glow <targets: entities> *reset\n/glow *reset")), false);
            return 1;
        })).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9306()).then(class_2170.method_9244((String)"displayplayers", (ArgumentType)class_2186.method_9308()).executes(context -> {
            Collection targets = class_2186.method_9317((CommandContext)context, (String)"targets");
            Collection displayPlayers = class_2186.method_9312((CommandContext)context, (String)"displayplayers");
            for (class_1297 target : targets) {
                GLOWING_MAP.put(target.method_5628(), displayPlayers.stream().map(class_1297::method_5628).toList());
                SelectiveGlowing.updateMetadata(target);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("%d entities are now glowing for %d player(s).", targets.size(), displayPlayers.size())), false);
            return 1;
        }))).then(class_2170.method_9247((String)"*reset").executes(context -> {
            Collection targets = class_2186.method_9317((CommandContext)context, (String)"targets");
            for (class_1297 target : targets) {
                GLOWING_MAP.remove(target.method_5628());
                SelectiveGlowing.updateMetadata(target);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Removed glowing overrides for %d entities.", targets.size())), false);
            return 1;
        })))).then(class_2170.method_9247((String)"*reset").executes(context -> {
            ArrayList<Integer> targetIds = new ArrayList<Integer>(GLOWING_MAP.keySet());
            GLOWING_MAP.clear();
            if (minecraftServer != null) {
                for (class_3218 world : minecraftServer.method_3738()) {
                    for (class_1297 entity : world.method_27909()) {
                        if (!targetIds.contains(entity.method_5628())) continue;
                        SelectiveGlowing.updateMetadata(entity);
                    }
                }
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)String.format("Removed glowing overrides for all %d entities.", targetIds.size())), false);
            return 1;
        }))));
    }

    private static void updateMetadata(class_1297 target) {
        try {
            if (FLAGS == null) {
                return;
            }
            byte bitmask = (Byte)target.method_5841().method_12789(FLAGS);
            for (class_1657 player : target.method_73183().method_18456()) {
                if (!(player instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)player;
                ArrayList<class_2945.class_7834> list = new ArrayList<class_2945.class_7834>();
                bitmask = SelectiveGlowing.isGlowing(target.method_5628(), serverPlayer) ? EntityData.GLOWING.setBit(bitmask) : EntityData.GLOWING.unsetBit(bitmask);
                list.add(new class_2945.class_7834(0, FLAGS.comp_2328(), (Object)bitmask));
                class_2739 packet = new class_2739(target.method_5628(), list);
                if (!(serverPlayer.method_5739(target) <= 60.0f)) continue;
                serverPlayer.field_13987.method_14364((class_2596)packet);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class_2940<Byte> getByteTrackedData() {
        Class<class_1297> entityClass = class_1297.class;
        try {
            Field field = entityClass.getDeclaredField("field_5990");
            field.setAccessible(true);
            return (class_2940)field.get(null);
        }
        catch (NoSuchFieldException e1) {
            try {
                Field field = entityClass.getDeclaredField("FLAGS");
                field.setAccessible(true);
                return (class_2940)field.get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException e2) {
                return null;
            }
        }
        catch (IllegalAccessException ignore) {
            return null;
        }
    }

    public static boolean isGlowing(int targetId, class_3222 observer) {
        if (SelectiveGlowing.isGlowing(targetId, observer.method_5628())) {
            return true;
        }
        class_3222 target = SelectiveGlowing.getPlayerById(observer.method_51469(), targetId);
        if (target == null) {
            return false;
        }
        return target.method_5851();
    }

    public static boolean isGlowing(int targetId, int observerId) {
        if (!GLOWING_MAP.containsKey(targetId)) {
            return false;
        }
        return GLOWING_MAP.get(targetId).contains(observerId);
    }

    public static class_3222 getPlayerById(class_3218 world, int id) {
        return world.method_18456().stream().filter(p -> p.method_5628() == id).findFirst().orElse(null);
    }

    public static class_2739 cloneAndOverridePacket(class_2739 packet, int observerId) {
        int targetId = packet.comp_1127();
        ArrayList<class_2945.class_7834> trackedValues = new ArrayList<class_2945.class_7834>();
        for (class_2945.class_7834 value : packet.comp_1128()) {
            if (value.comp_1115() == 0) {
                byte bitmask = (Byte)value.comp_1117();
                if (SelectiveGlowing.isGlowing(targetId, observerId)) {
                    bitmask = EntityData.GLOWING.setBit(bitmask);
                }
                class_2945.class_7834 newEntry = new class_2945.class_7834(0, value.comp_1116(), (Object)bitmask);
                trackedValues.add(newEntry);
                continue;
            }
            trackedValues.add(value);
        }
        return new class_2739(targetId, trackedValues);
    }
}

