/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.zip.InflaterInputStream;
import net.minecraft.class_5699;
import net.minecraft.class_6910;
import net.minecraft.class_7243;

public record SingleChannelImageTessellation(int xSize, int zSize, byte[] inflatedFrameData) implements class_6910
{
    private static final MapCodec<SingleChannelImageTessellation> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33442.fieldOf("x_size").forGetter(SingleChannelImageTessellation::xSize), (App)class_5699.field_33442.fieldOf("z_size").forGetter(SingleChannelImageTessellation::zSize), (App)class_5699.field_39273.fieldOf("deflated_frame_data").forGetter(SingleChannelImageTessellation::inflatedFrameData)).apply((Applicative)instance, SingleChannelImageTessellation::create));
    public static final TypedCodec<SingleChannelImageTessellation> TYPED_CODEC = new TypedCodec("single_channel_image_tessellation", class_7243.method_42116(MAP_CODEC));

    private static SingleChannelImageTessellation create(int xSize, int zSize, byte[] deflatedFrameData) {
        byte[] inflatedBytes;
        try {
            InflaterInputStream inflaterStream = new InflaterInputStream(new ByteArrayInputStream(deflatedFrameData));
            inflatedBytes = inflaterStream.readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Error: More Density Functions failed to decompress frame data", e);
        }
        return new SingleChannelImageTessellation(xSize, zSize, inflatedBytes);
    }

    public double method_40464(class_6910.class_6912 pos) {
        int x = pos.comp_371();
        int z = pos.comp_373();
        int arrayPos = StrictMath.floorMod(x, this.xSize) + StrictMath.floorMod(z, this.zSize) * this.xSize;
        return this.inflatedFrameData[arrayPos] & 0xFF;
    }

    public void method_40470(double[] densities, class_6910.class_6911 applier) {
        applier.method_40478(densities, (class_6910)this);
    }

    public class_6910 method_40469(class_6910.class_6915 visitor) {
        return visitor.apply((class_6910)new SingleChannelImageTessellation(this.xSize, this.zSize, this.inflatedFrameData));
    }

    public double comp_377() {
        return 0.0;
    }

    public double comp_378() {
        return 255.0;
    }

    public class_7243<? extends class_6910> method_41062() {
        return TYPED_CODEC.codec();
    }
}

