/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.MoreDensityFunctionsConstants;
import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record GappedGridSquareSpiral(int xSize, int zSize, int spacing, DensityFunction[] gridCellArgs, DensityFunction oobArg) implements DensityFunction
{
    private static final MapCodec<GappedGridSquareSpiral> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("x_size").forGetter(GappedGridSquareSpiral::xSize), (App)ExtraCodecs.f_144629_.fieldOf("z_size").forGetter(GappedGridSquareSpiral::zSize), (App)ExtraCodecs.f_144629_.fieldOf("spacing").orElse((Object)1).forGetter(GappedGridSquareSpiral::spacing), (App)MoreDensityFunctionsConstants.DENSITY_FUNCTION_ARRAY_CODEC.fieldOf("grid_cell_args").forGetter(GappedGridSquareSpiral::gridCellArgs), (App)DensityFunction.f_208218_.fieldOf("out_of_bounds_argument").orElse((Object)DensityFunctions.m_208264_((double)-1.0)).forGetter(GappedGridSquareSpiral::oobArg)).apply((Applicative)instance, GappedGridSquareSpiral::create));
    public static final TypedCodec<GappedGridSquareSpiral> TYPED_CODEC = new TypedCodec("gapped_grid_square_spiral", KeyDispatchDataCodec.m_216238_(MAP_CODEC));

    private static GappedGridSquareSpiral create(int xSize, int zSize, int spacing, DensityFunction[] gridCellArgs, DensityFunction oobArg) {
        return new GappedGridSquareSpiral(xSize, zSize, spacing + 1, gridCellArgs, oobArg);
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        int numFunctions;
        int gridX = StrictMath.floorDiv(pos.m_207115_(), this.xSize);
        int gridZ = StrictMath.floorDiv(pos.m_207113_(), this.zSize);
        if (gridX % this.spacing != 0 || gridZ % this.spacing != 0) {
            return this.oobArg.m_207386_(pos);
        }
        int normalizedGridX = gridX / this.spacing;
        int normalizedGridZ = gridZ / this.spacing;
        int index = GappedGridSquareSpiral.getSpiralIndex(normalizedGridX, normalizedGridZ);
        if (index >= (numFunctions = this.gridCellArgs.length)) {
            return this.oobArg.m_207386_(pos);
        }
        DensityFunction arg = this.gridCellArgs[index];
        return arg.m_207386_(pos);
    }

    private static int getSpiralIndex(int spiralX, int spiralZ) {
        if (spiralX == 0 && spiralZ == 0) {
            return 0;
        }
        int ring = StrictMath.max(StrictMath.abs(spiralX), StrictMath.abs(spiralZ));
        int index = 1 + 4 * ring * (ring - 1);
        int indexOffset = GappedGridSquareSpiral.getOffsetFromStartIndex(spiralX, spiralZ, ring);
        return index + indexOffset;
    }

    private static int getOffsetFromStartIndex(int spiralX, int spiralZ, int ring) {
        int positionInRing;
        if (spiralX == ring && spiralZ >= -ring && spiralZ < ring) {
            positionInRing = spiralZ + ring;
        } else if (spiralZ == ring && spiralX <= ring && spiralX > -ring) {
            positionInRing = ring * 2 + (ring - spiralX);
        } else if (spiralX == -ring && spiralZ <= ring && spiralZ > -ring) {
            positionInRing = ring * 4 + (ring - spiralZ);
        } else if (spiralZ == -ring && spiralX >= -ring && spiralX < ring) {
            positionInRing = ring * 6 + (spiralX + ring);
        } else {
            throw new IllegalArgumentException("Invalid coordinate (" + spiralX + ", " + spiralZ + ") for spiral");
        }
        return positionInRing;
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new GappedGridSquareSpiral(this.xSize, this.zSize, this.spacing, this.gridCellArgs, this.oobArg.m_207456_(visitor)));
    }

    public double m_207402_() {
        return StrictMath.min(this.oobArg.m_207402_(), 0.0);
    }

    public double m_207401_() {
        return StrictMath.max(this.oobArg.m_207401_(), 255.0);
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return TYPED_CODEC.codec();
    }
}

