/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Log(DensityFunction arg, DensityFunction base) implements DensityFunction
{
    private static final MapCodec<Log> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument").forGetter(Log::arg), (App)DensityFunction.f_208218_.fieldOf("base").forGetter(Log::base)).apply((Applicative)instance, Log::new));
    public static final TypedCodec<Log> TYPED_CODEC = new TypedCodec("log", KeyDispatchDataCodec.m_216238_(MAP_CODEC));

    private static double eval(double arg, double base) {
        return StrictMath.log(arg / StrictMath.log(base));
    }

    public double m_207386_(DensityFunction.FunctionContext pos) {
        return Log.eval(this.arg.m_207386_(pos), this.base.m_207386_(pos));
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        return visitor.m_214017_((DensityFunction)new Log(this.arg.m_207456_(visitor), this.base.m_207456_(visitor)));
    }

    private static BaseRange findBaseRange(double min, double max) {
        if (min > 0.0 && min < 1.0 && max > 0.0 && max < 1.0) {
            return BaseRange.ZERO_TO_ONE_EXCLUSIVE;
        }
        if (min > 1.0) {
            return BaseRange.ONE_TO_INFINITY_EXCLUSIVE;
        }
        return BaseRange.INVALID;
    }

    public double m_207402_() {
        double asymptoteLocation = 0.0;
        double baseMin = this.base.m_207402_();
        double baseMax = this.base.m_207401_();
        return switch (Log.findBaseRange(baseMin, baseMax)) {
            default -> throw new IncompatibleClassChangeError();
            case BaseRange.ZERO_TO_ONE_EXCLUSIVE -> {
                double argMax = this.arg.m_207401_();
                yield StrictMath.min(Log.eval(argMax, baseMin), Log.eval(argMax, baseMax));
            }
            case BaseRange.ONE_TO_INFINITY_EXCLUSIVE -> {
                double argMin = this.arg.m_207402_();
                if (argMin > asymptoteLocation) {
                    yield StrictMath.min(Log.eval(argMin, baseMin), Log.eval(argMin, baseMax));
                }
                double argMax = this.arg.m_207401_();
                if (argMax < asymptoteLocation) {
                    yield Double.NaN;
                }
                yield Double.NEGATIVE_INFINITY;
            }
            case BaseRange.INVALID -> Double.NaN;
        };
    }

    public double m_207401_() {
        double asymptoteLocation = 0.0;
        double baseMin = this.base.m_207402_();
        double baseMax = this.base.m_207401_();
        return switch (Log.findBaseRange(baseMin, baseMax)) {
            default -> throw new IncompatibleClassChangeError();
            case BaseRange.ZERO_TO_ONE_EXCLUSIVE -> {
                double argMin = this.arg.m_207402_();
                if (argMin > asymptoteLocation) {
                    yield StrictMath.max(Log.eval(argMin, baseMin), Log.eval(argMin, baseMax));
                }
                double argMax = this.arg.m_207401_();
                if (argMax < asymptoteLocation) {
                    yield Double.NaN;
                }
                yield Double.POSITIVE_INFINITY;
            }
            case BaseRange.ONE_TO_INFINITY_EXCLUSIVE -> {
                double argMax = this.arg.m_207401_();
                yield StrictMath.min(Log.eval(argMax, baseMin), Log.eval(argMax, baseMax));
            }
            case BaseRange.INVALID -> Double.NaN;
        };
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return TYPED_CODEC.codec();
    }

    private static enum BaseRange {
        ZERO_TO_ONE_EXCLUSIVE,
        ONE_TO_INFINITY_EXCLUSIVE,
        INVALID;

    }
}

