/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public interface NoiseDensityFunction
extends DensityFunction {
    public ExtraOctaves extraOctaves();

    public int salt();

    public double eval(int var1, int var2, int var3);

    default public double m_207386_(DensityFunction.FunctionContext context) {
        int x = context.m_207115_();
        int y = context.m_207114_();
        int z = context.m_207113_();
        double noiseResult = this.eval(x, y, z);
        if (this.extraOctaves().isSingleOctave()) {
            return noiseResult;
        }
        double[] frequencies = this.extraOctaves().frequencies;
        double[] amplitudes = this.extraOctaves().amplitudes;
        int[] offsetsX = this.extraOctaves().offsetsX;
        int[] offsetsY = this.extraOctaves().offsetsY;
        int[] offsetsZ = this.extraOctaves().offsetsZ;
        for (int i = 0; i < frequencies.length; ++i) {
            noiseResult += amplitudes[i] * this.eval(Mth.m_14107_((double)((double)(x + offsetsX[i]) * frequencies[i])), Mth.m_14107_((double)((double)(y + offsetsY[i]) * frequencies[i])), Mth.m_14107_((double)((double)(z + offsetsZ[i]) * frequencies[i])));
        }
        return noiseResult;
    }

    public static int safeFloorDiv(int numerator, int denominator) {
        if (denominator == 0) {
            return 0;
        }
        return StrictMath.floorDiv(numerator, denominator);
    }

    default public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public record ExtraOctaves(int count, double lacunarity, double persistence, double[] frequencies, double[] amplitudes, double maxAmplitude, int[] offsetsX, int[] offsetsY, int[] offsetsZ) {
        public static final Codec<ExtraOctaves> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144628_.fieldOf("count").forGetter(ExtraOctaves::count), (App)Codec.DOUBLE.fieldOf("lacunarity").forGetter(ExtraOctaves::lacunarity), (App)Codec.DOUBLE.fieldOf("persistence").forGetter(ExtraOctaves::persistence)).apply((Applicative)instance, ExtraOctaves::tempNoSalt));

        public static ExtraOctaves getDefault() {
            return new ExtraOctaves(0, 0.0, 0.0, null, null, 1.0, null, null, null);
        }

        public boolean isSingleOctave() {
            return this.count == 0;
        }

        private static ExtraOctaves tempNoSalt(int count, double lacunarity, double persistence) {
            if (count == 0) {
                return ExtraOctaves.getDefault();
            }
            double[] amplitudes = ExtraOctaves.computeNoiseRatios(count, persistence);
            double[] frequencies = ExtraOctaves.computeNoiseRatios(count, lacunarity);
            double maxAmplitude = ExtraOctaves.computeAmplitudesSum(count, persistence);
            return new ExtraOctaves(count, lacunarity, persistence, frequencies, amplitudes, maxAmplitude, null, null, null);
        }

        public ExtraOctaves finalizedWithSalt(int salt) {
            if (this.count == 0 || this.offsetsX != null) {
                return this;
            }
            int[] offsetX = ExtraOctaves.createOffsetsForAxis(this.count, salt, 12345);
            int[] offsetY = ExtraOctaves.createOffsetsForAxis(this.count, salt, 67890);
            int[] offsetZ = ExtraOctaves.createOffsetsForAxis(this.count, salt, 24680);
            return new ExtraOctaves(this.count, this.lacunarity, this.persistence, this.frequencies, this.amplitudes, this.maxAmplitude, offsetX, offsetY, offsetZ);
        }

        private static int[] createOffsetsForAxis(int count, int baseSalt, int axisSalt) {
            int[] offsets = new int[count];
            long seed = RandomSampler.hashPosition(baseSalt, axisSalt, 0, 0);
            for (int i = 0; i < count; ++i) {
                offsets[i] = (int)(seed & 0x7FFFFFFL);
                seed = RandomSampler.mix(seed);
            }
            return offsets;
        }

        private static double[] computeNoiseRatios(int octaves, double ratio) {
            double[] ratios = new double[octaves];
            double currRatio = ratio;
            for (int i = 0; i < octaves; ++i) {
                ratios[i] = currRatio;
                currRatio *= ratio;
            }
            return ratios;
        }

        private static double computeAmplitudesSum(int count, double ratio) {
            if (ratio == 1.0) {
                return count;
            }
            return ratio * (StrictMath.pow(ratio, count) - 1.0) / (ratio - 1.0);
        }
    }
}

