/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Profiler(DensityFunction arg, int iterations, int warmUp) implements DensityFunction
{
    private static final MapCodec<Profiler> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.f_208218_.fieldOf("argument").forGetter(Profiler::arg), (App)ExtraCodecs.f_144628_.fieldOf("iterations").forGetter(Profiler::iterations), (App)ExtraCodecs.f_144628_.fieldOf("warm_up").forGetter(Profiler::warmUp)).apply((Applicative)instance, Profiler::new));
    public static final TypedCodec<Profiler> TYPED_CODEC = new TypedCodec("profiler", KeyDispatchDataCodec.m_216238_(MAP_CODEC));
    private static final Set<DensityFunction> inactiveProfilers = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public double m_207386_(DensityFunction.FunctionContext pos) {
        int i;
        if (inactiveProfilers.contains(this.arg)) {
            return this.arg.m_207386_(pos);
        }
        System.out.println("\nBeginning Profile of Density Function: " + String.valueOf(this.arg));
        long[] warmUpTimes = new long[this.warmUp];
        long[] iterationTimes = new long[this.iterations];
        for (i = 0; i < this.warmUp; ++i) {
            long startWarmUp = System.nanoTime();
            this.arg.m_207386_(pos);
            long warmupFinish = System.nanoTime();
            warmUpTimes[i] = warmupFinish - startWarmUp;
        }
        System.gc();
        for (i = 0; i < this.iterations; ++i) {
            long startIteration = System.nanoTime();
            this.arg.m_207386_(pos);
            long iterationFinish = System.nanoTime();
            iterationTimes[i] = iterationFinish - startIteration;
        }
        double avgWarmUpTime = Arrays.stream(warmUpTimes).average().orElse(0.0);
        double avgIterationTime = Arrays.stream(iterationTimes).average().orElse(0.0);
        System.out.printf("Profile of %,d iterations:\nAvg. Time per Compute (warm-up stage): %,.3fns\nAvg. Time per Compute (profile stage): %,.3fns\nProfile Time: %,.3fs\n", this.iterations, avgWarmUpTime, avgIterationTime, (avgWarmUpTime * (double)this.warmUp + avgIterationTime * (double)this.iterations) / 1.0E9);
        inactiveProfilers.add(this.arg);
        return this.arg.m_207386_(pos);
    }

    public void m_207362_(double[] densities, DensityFunction.ContextProvider applier) {
        applier.m_207207_(densities, (DensityFunction)this);
    }

    public DensityFunction m_207456_(DensityFunction.Visitor visitor) {
        if (!inactiveProfilers.contains(this.arg)) {
            inactiveProfilers.add(this.arg);
            return new Profiler(this.arg.m_207456_(visitor), this.iterations, this.warmUp);
        }
        return visitor.m_214017_(this.arg.m_207456_(visitor));
    }

    public double m_207402_() {
        return this.arg.m_207402_();
    }

    public double m_207401_() {
        return this.arg.m_207401_();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return TYPED_CODEC.codec();
    }
}

