/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record GradientMagnitude(DensityFunction arg, int stepX, int stepY, int stepZ) implements DensityFunction
{
    public static final MapCodec<GradientMagnitude> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(GradientMagnitude::arg), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("step_x").orElse((Object)0).forGetter(GradientMagnitude::stepX), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("step_y").orElse((Object)0).forGetter(GradientMagnitude::stepY), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("step_z").orElse((Object)0).forGetter(GradientMagnitude::stepZ)).apply((Applicative)instance, GradientMagnitude::create));
    public static final TypedCodec<GradientMagnitude> TYPED_CODEC = new TypedCodec("gradient_magnitude", KeyDispatchDataCodec.of(MAP_CODEC));

    private static GradientMagnitude create(DensityFunction arg, int stepX, int stepY, int stepZ) {
        if ((stepX | stepY | stepZ) == 0) {
            throw new IllegalArgumentException("Gradient Magnitude must contain at least one non-zero step component!");
        }
        return new GradientMagnitude(arg, stepX, stepY, stepZ);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        int x = pos.blockX();
        int y = pos.blockY();
        int z = pos.blockZ();
        double gradX = 0.0;
        double gradY = 0.0;
        double gradZ = 0.0;
        if (this.stepX != 0) {
            gradX = (this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x + this.stepX, y, z)) - this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x - this.stepX, y, z))) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            gradY = (this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y + this.stepY, z)) - this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y - this.stepY, z))) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            gradZ = (this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y, z + this.stepZ)) - this.arg.compute((DensityFunction.FunctionContext)new BlockContext(x, y, z - this.stepZ))) / (2.0 * (double)this.stepZ);
        }
        if (this.stepY == 0 && this.stepZ == 0) {
            return StrictMath.abs(gradX);
        }
        if (this.stepX == 0 && this.stepZ == 0) {
            return StrictMath.abs(gradY);
        }
        if (this.stepX == 0 && this.stepY == 0) {
            return StrictMath.abs(gradZ);
        }
        return StrictMath.sqrt(gradX * gradX + gradY * gradY + gradZ * gradZ);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new GradientMagnitude(this.arg.mapAll(visitor), this.stepX, this.stepY, this.stepZ));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public double minValue() {
        double minGradX = 0.0;
        double minGradY = 0.0;
        double minGradZ = 0.0;
        if (this.stepX != 0) {
            minGradX = (this.arg.minValue() - this.arg.maxValue()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            minGradY = (this.arg.minValue() - this.arg.maxValue()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            minGradZ = (this.arg.minValue() - this.arg.maxValue()) / (2.0 * (double)this.stepZ);
        }
        return minGradX * minGradX + minGradY * minGradY + minGradZ * minGradZ;
    }

    public double maxValue() {
        double maxGradX = 0.0;
        double maxGradY = 0.0;
        double maxGradZ = 0.0;
        if (this.stepX != 0) {
            maxGradX = (this.arg.maxValue() - this.arg.minValue()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            maxGradY = (this.arg.maxValue() - this.arg.minValue()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            maxGradZ = (this.arg.maxValue() - this.arg.minValue()) / (2.0 * (double)this.stepZ);
        }
        return maxGradX * maxGradX + maxGradY * maxGradY + maxGradZ * maxGradZ;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }

    private record BlockContext(int blockX, int blockY, int blockZ) implements DensityFunction.FunctionContext
    {
    }
}

