/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record HyperbolicCosine(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<HyperbolicCosine> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(HyperbolicCosine::arg)).apply((Applicative)instance, HyperbolicCosine::new));
    public static final TypedCodec<HyperbolicCosine> TYPED_CODEC = new TypedCodec("cosh", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double density) {
        return StrictMath.cosh(density);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return HyperbolicCosine.eval(this.arg.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new HyperbolicCosine(this.arg.mapAll(visitor)));
    }

    public double minValue() {
        double globalMinLocation = 0.0;
        double argMin = this.arg.minValue();
        if (argMin > globalMinLocation) {
            return HyperbolicCosine.eval(argMin);
        }
        double argMax = this.arg.maxValue();
        if (argMax > globalMinLocation) {
            return 1.0;
        }
        return HyperbolicCosine.eval(argMax);
    }

    public double maxValue() {
        return HyperbolicCosine.eval(Mth.absMax((double)this.arg.minValue(), (double)this.arg.maxValue()));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

