/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Log(DensityFunction arg, DensityFunction base) implements DensityFunction
{
    private static final MapCodec<Log> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Log::arg), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("base").forGetter(Log::base)).apply((Applicative)instance, Log::new));
    public static final TypedCodec<Log> TYPED_CODEC = new TypedCodec("log", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double arg, double base) {
        return StrictMath.log(arg / StrictMath.log(base));
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return Log.eval(this.arg.compute(pos), this.base.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Log(this.arg.mapAll(visitor), this.base.mapAll(visitor)));
    }

    private static BaseRange findBaseRange(double min, double max) {
        if (min > 0.0 && min < 1.0 && max > 0.0 && max < 1.0) {
            return BaseRange.ZERO_TO_ONE_EXCLUSIVE;
        }
        if (min > 1.0) {
            return BaseRange.ONE_TO_INFINITY_EXCLUSIVE;
        }
        return BaseRange.INVALID;
    }

    public double minValue() {
        double asymptoteLocation = 0.0;
        double baseMin = this.base.minValue();
        double baseMax = this.base.maxValue();
        return switch (Log.findBaseRange(baseMin, baseMax).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                double argMax = this.arg.maxValue();
                yield StrictMath.min(Log.eval(argMax, baseMin), Log.eval(argMax, baseMax));
            }
            case 1 -> {
                double argMin = this.arg.minValue();
                if (argMin > asymptoteLocation) {
                    yield StrictMath.min(Log.eval(argMin, baseMin), Log.eval(argMin, baseMax));
                }
                double argMax = this.arg.maxValue();
                if (argMax < asymptoteLocation) {
                    yield Double.NaN;
                }
                yield Double.NEGATIVE_INFINITY;
            }
            case 2 -> Double.NaN;
        };
    }

    public double maxValue() {
        double asymptoteLocation = 0.0;
        double baseMin = this.base.minValue();
        double baseMax = this.base.maxValue();
        return switch (Log.findBaseRange(baseMin, baseMax).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                double argMin = this.arg.minValue();
                if (argMin > asymptoteLocation) {
                    yield StrictMath.max(Log.eval(argMin, baseMin), Log.eval(argMin, baseMax));
                }
                double argMax = this.arg.maxValue();
                if (argMax < asymptoteLocation) {
                    yield Double.NaN;
                }
                yield Double.POSITIVE_INFINITY;
            }
            case 1 -> {
                double argMax = this.arg.maxValue();
                yield StrictMath.min(Log.eval(argMax, baseMin), Log.eval(argMax, baseMax));
            }
            case 2 -> Double.NaN;
        };
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }

    private static enum BaseRange {
        ZERO_TO_ONE_EXCLUSIVE,
        ONE_TO_INFINITY_EXCLUSIVE,
        INVALID;

    }
}

