/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Log2(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<Log2> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Log2::arg)).apply((Applicative)instance, Log2::new));
    public static final TypedCodec<Log2> TYPED_CODEC = new TypedCodec("log2", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double density) {
        return StrictMath.log(density) * 1.4426950408889634;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return Log2.eval(this.arg.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Log2(this.arg.mapAll(visitor)));
    }

    public double minValue() {
        double asymptoteLocation = 0.0;
        double argMin = this.arg.minValue();
        if (argMin > asymptoteLocation) {
            return Log2.eval(argMin);
        }
        double argMax = this.arg.maxValue();
        if (argMax < asymptoteLocation) {
            return Double.NaN;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double maxValue() {
        return Log2.eval(this.arg.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

