/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Log2Floor(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<Log2Floor> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Log2Floor::arg)).apply((Applicative)instance, Log2Floor::new));
    public static final TypedCodec<Log2Floor> TYPED_CODEC = new TypedCodec("log2_floor", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double density) {
        long bits = Double.doubleToLongBits(density);
        return (int)(bits >>> 52 & 0x7FFL) - 1023;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return Log2Floor.eval(this.arg.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Log2Floor(this.arg.mapAll(visitor)));
    }

    public double minValue() {
        double symmetricAsymptoteLocation = 0.0;
        double argMin = this.arg.minValue();
        if (argMin > symmetricAsymptoteLocation) {
            return Log2Floor.eval(argMin);
        }
        double argMax = this.arg.maxValue();
        if (argMax < symmetricAsymptoteLocation) {
            return Log2Floor.eval(argMax);
        }
        return -1023.0;
    }

    public double maxValue() {
        return Log2Floor.eval(Mth.absMax((double)this.arg.minValue(), (double)this.arg.maxValue()));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

