/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record NaturalLog(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<NaturalLog> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(NaturalLog::arg)).apply((Applicative)instance, NaturalLog::new));
    public static final TypedCodec<NaturalLog> TYPED_CODEC = new TypedCodec("ln", KeyDispatchDataCodec.of(MAP_CODEC));

    public double compute(DensityFunction.FunctionContext pos) {
        return NaturalLog.eval(this.arg.compute(pos));
    }

    private static double eval(double density) {
        return StrictMath.log(density);
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new NaturalLog(this.arg.mapAll(visitor)));
    }

    public double minValue() {
        double asymptoteLocation = 0.0;
        double argMin = this.arg.minValue();
        if (argMin > asymptoteLocation) {
            return NaturalLog.eval(argMin);
        }
        double argMax = this.arg.maxValue();
        if (argMax < asymptoteLocation) {
            return Double.NaN;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public double maxValue() {
        return NaturalLog.eval(this.arg.maxValue());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

