/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.serialization.MapCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record PolarCoords() implements DensityFunction
{
    private static final MapCodec<PolarCoords> MAP_CODEC = MapCodec.unit((Object)new PolarCoords());
    public static final TypedCodec<PolarCoords> TYPED_CODEC = new TypedCodec("polar_coords", KeyDispatchDataCodec.of(MAP_CODEC));

    public double compute(DensityFunction.FunctionContext pos) {
        return StrictMath.atan2(pos.blockX(), pos.blockZ());
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new PolarCoords());
    }

    public double minValue() {
        return -Math.PI;
    }

    public double maxValue() {
        return Math.PI;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

