/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.randomsamplers;

import com.klinbee.moredensityfunctions.randomsamplers.RandomSampler;
import com.klinbee.moredensityfunctions.registration.AnonymousTypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;

public record GeometricSampler(double probability, double inverseLog1p) implements RandomSampler
{
    private static final MapCodec<GeometricSampler> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.doubleRange((double)Double.MIN_NORMAL, (double)1.0).fieldOf("probability").forGetter(GeometricSampler::probability)).apply((Applicative)instance, GeometricSampler::create));
    public static final AnonymousTypedCodec<GeometricSampler> ANON_CODEC = new AnonymousTypedCodec<GeometricSampler>("geometric", CODEC);

    public static GeometricSampler create(double probability) {
        double inverseLog1p = 1.0 / StrictMath.log(1.0 - probability);
        return new GeometricSampler(probability, inverseLog1p);
    }

    @Override
    public double sample(long hashedSeed) {
        return Mth.ceil((double)(this.inverseLog1p * StrictMath.log(1.0 - RandomSampler.sampleDouble(hashedSeed))));
    }

    @Override
    public double minValue() {
        return 1.0;
    }

    @Override
    public double maxValue() {
        return Double.MAX_VALUE;
    }

    @Override
    public AnonymousTypedCodec<? extends RandomSampler> anonCodec() {
        return ANON_CODEC;
    }
}

