/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record ArcCosine(DensityFunction arg) implements DensityFunction
{
    private static final MapCodec<ArcCosine> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(ArcCosine::arg)).apply((Applicative)instance, ArcCosine::new));
    public static final TypedCodec<ArcCosine> TYPED_CODEC = new TypedCodec("acos", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double density) {
        return StrictMath.acos(density);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return ArcCosine.eval(this.arg.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new ArcCosine(this.arg.mapAll(visitor)));
    }

    public double minValue() {
        double rangeMinLocation = 1.0;
        double argMin = this.arg.minValue();
        if (argMin > rangeMinLocation) {
            return Double.NaN;
        }
        double argMax = this.arg.maxValue();
        if (argMax > rangeMinLocation) {
            return 0.0;
        }
        return ArcCosine.eval(argMax);
    }

    public double maxValue() {
        double rangeMaxLocation = -1.0;
        double argMax = this.arg.maxValue();
        if (argMax < rangeMaxLocation) {
            return Double.NaN;
        }
        double argMin = this.arg.minValue();
        if (argMin < rangeMaxLocation) {
            return Math.PI;
        }
        return ArcCosine.eval(argMin);
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

