/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Clamp(DensityFunction arg, double min, double max) implements DensityFunction
{
    private static final MapCodec<Clamp> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Clamp::arg), (App)Codec.doubleRange((double)-1.7976931348623157E308, (double)Double.MAX_VALUE).fieldOf("min").forGetter(Clamp::min), (App)Codec.doubleRange((double)-1.7976931348623157E308, (double)Double.MAX_VALUE).fieldOf("max").forGetter(Clamp::max)).apply((Applicative)instance, Clamp::create));
    public static final TypedCodec<Clamp> TYPED_CODEC = new TypedCodec("clamp", KeyDispatchDataCodec.of(MAP_CODEC));

    private static Clamp create(DensityFunction arg, double min, double max) {
        if (min > max) {
            throw new IllegalArgumentException("Min must be less than max! min: " + min + " max: " + max);
        }
        return new Clamp(arg, min, max);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return Mth.clamp((double)this.arg.compute(pos), (double)this.min, (double)this.max);
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Clamp(this.arg.mapAll(visitor), this.min, this.max));
    }

    public double minValue() {
        return StrictMath.min(this.arg.minValue(), this.min);
    }

    public double maxValue() {
        return StrictMath.max(this.arg.maxValue(), this.max);
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

