/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.MoreDensityFunctionsConstants;
import com.klinbee.moredensityfunctions.distancemetrics.DistanceMetric;
import com.klinbee.moredensityfunctions.distancemetrics.Linear;
import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;

public record Distance(DistanceMetric distanceMetric, DensityFunction[] point1, DensityFunction[] point2) implements DensityFunction
{
    private static final MapCodec<Distance> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DistanceMetric.CODEC.fieldOf("distance_metric").forGetter(Distance::distanceMetric), (App)MoreDensityFunctionsConstants.DENSITY_FUNCTION_ARRAY_CODEC.fieldOf("point1").forGetter(Distance::point1), (App)MoreDensityFunctionsConstants.DENSITY_FUNCTION_ARRAY_CODEC.fieldOf("point2").forGetter(Distance::point2)).apply((Applicative)instance, Distance::create));
    public static final TypedCodec<Distance> TYPED_CODEC = new TypedCodec("distance", KeyDispatchDataCodec.of(MAP_CODEC));

    private static Distance create(DistanceMetric distanceMetric, DensityFunction[] point1, DensityFunction[] point2) {
        if (point1.length == 0 && point2.length == 0) {
            throw new IllegalArgumentException("Distance points' dimension must be above 0!");
        }
        if (point1.length == 0) {
            point1 = new DensityFunction[point2.length];
            Arrays.fill(point1, DensityFunctions.constant((double)0.0));
        }
        if (point2.length == 0) {
            point2 = new DensityFunction[point1.length];
            Arrays.fill(point2, DensityFunctions.constant((double)0.0));
        }
        if (point1.length != point2.length) {
            throw new IllegalArgumentException("Distance points must have the same dimension!");
        }
        if (point1.length == 1) {
            return new Distance(new Linear(), point1, point2);
        }
        return new Distance(distanceMetric, point1, point2);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        double[] values1 = new double[this.point1.length];
        double[] values2 = new double[this.point2.length];
        for (int i = 0; i < this.point1.length; ++i) {
            values1[i] = this.point1[i].compute(pos);
            values2[i] = this.point2[i].compute(pos);
        }
        return this.distanceMetric.distance(values1, values2);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        for (int i = 0; i < this.point1.length; ++i) {
            this.point1[i].mapAll(visitor);
            this.point2[i].mapAll(visitor);
        }
        return visitor.apply((DensityFunction)new Distance(this.distanceMetric, this.point1, this.point2));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    private double[] minAbsDiffs() {
        double[] minAbsDiffs = new double[this.point1.length];
        for (int i = 0; i < this.point1.length; ++i) {
            double p1Min = this.point1[i].minValue();
            double p1Max = this.point1[i].maxValue();
            double p2Min = this.point2[i].minValue();
            double p2Max = this.point2[i].maxValue();
            double diffMin = p2Min - p1Max;
            double diffMax = p2Max - p1Min;
            minAbsDiffs[i] = diffMin <= 0.0 && diffMax >= 0.0 ? 0.0 : StrictMath.min(StrictMath.abs(diffMin), StrictMath.abs(diffMax));
        }
        return minAbsDiffs;
    }

    private double[] maxAbsDiffs() {
        double[] maxAbsDiffs = new double[this.point1.length];
        for (int i = 0; i < this.point1.length; ++i) {
            double p1Min = this.point1[i].minValue();
            double p1Max = this.point1[i].maxValue();
            double p2Min = this.point2[i].minValue();
            double p2Max = this.point2[i].maxValue();
            double diffMin = p2Min - p1Max;
            double diffMax = p2Max - p1Min;
            maxAbsDiffs[i] = StrictMath.max(StrictMath.abs(diffMin), StrictMath.abs(diffMax));
        }
        return maxAbsDiffs;
    }

    public double minValue() {
        return this.distanceMetric.minValue(this.minAbsDiffs());
    }

    public double maxValue() {
        return this.distanceMetric.maxValue(this.maxAbsDiffs());
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

