/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record DotProduct(DensityFunction arg1, DensityFunction arg2, int stepX, int stepY, int stepZ) implements DensityFunction
{
    public static final MapCodec<DotProduct> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument1").forGetter(DotProduct::arg1), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument2").forGetter(DotProduct::arg2), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("step_x").orElse((Object)0).forGetter(DotProduct::stepX), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("step_y").orElse((Object)0).forGetter(DotProduct::stepY), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("step_z").orElse((Object)0).forGetter(DotProduct::stepZ)).apply((Applicative)instance, DotProduct::create));
    public static final TypedCodec<DotProduct> TYPED_CODEC = new TypedCodec("dot_product", KeyDispatchDataCodec.of(MAP_CODEC));

    private static DotProduct create(DensityFunction arg1, DensityFunction arg2, int stepX, int stepY, int stepZ) {
        if ((stepX | stepY | stepZ) == 0) {
            throw new IllegalArgumentException("Dot Product must contain at least one non-zero step component!");
        }
        return new DotProduct(arg1, arg2, stepX, stepY, stepZ);
    }

    public double compute(DensityFunction.FunctionContext pos) {
        BlockContext posBackwards;
        BlockContext posForwards;
        int x = pos.blockX();
        int y = pos.blockY();
        int z = pos.blockZ();
        double gradX1 = 0.0;
        double gradY1 = 0.0;
        double gradZ1 = 0.0;
        double gradX2 = 0.0;
        double gradY2 = 0.0;
        double gradZ2 = 0.0;
        if (this.stepX != 0) {
            posForwards = new BlockContext(x + this.stepX, y, z);
            posBackwards = new BlockContext(x - this.stepX, y, z);
            gradX1 = (this.arg1.compute((DensityFunction.FunctionContext)posForwards) - this.arg1.compute((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepX);
            gradX2 = (this.arg2.compute((DensityFunction.FunctionContext)posForwards) - this.arg2.compute((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            posForwards = new BlockContext(x, y + this.stepY, z);
            posBackwards = new BlockContext(x, y - this.stepY, z);
            gradY1 = (this.arg1.compute((DensityFunction.FunctionContext)posForwards) - this.arg1.compute((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepY);
            gradY2 = (this.arg2.compute((DensityFunction.FunctionContext)posForwards) - this.arg2.compute((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            posForwards = new BlockContext(x, y, z + this.stepZ);
            posBackwards = new BlockContext(x, y, z - this.stepZ);
            gradZ1 = (this.arg1.compute((DensityFunction.FunctionContext)posForwards) - this.arg1.compute((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepZ);
            gradZ2 = (this.arg2.compute((DensityFunction.FunctionContext)posForwards) - this.arg2.compute((DensityFunction.FunctionContext)posBackwards)) / (2.0 * (double)this.stepZ);
        }
        return gradX1 * gradX2 + gradY1 * gradY2 + gradZ1 * gradZ2;
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new DotProduct(this.arg1.mapAll(visitor), this.arg2.mapAll(visitor), this.stepX, this.stepY, this.stepZ));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public double minValue() {
        double minGradX1 = 0.0;
        double minGradY1 = 0.0;
        double minGradZ1 = 0.0;
        double minGradX2 = 0.0;
        double minGradY2 = 0.0;
        double minGradZ2 = 0.0;
        if (this.stepX != 0) {
            minGradX1 = (this.arg1.minValue() - this.arg1.maxValue()) / (2.0 * (double)this.stepX);
            minGradX2 = (this.arg2.minValue() - this.arg2.maxValue()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            minGradY1 = (this.arg1.minValue() - this.arg1.maxValue()) / (2.0 * (double)this.stepY);
            minGradY2 = (this.arg2.minValue() - this.arg2.maxValue()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            minGradZ1 = (this.arg1.minValue() - this.arg1.maxValue()) / (2.0 * (double)this.stepZ);
            minGradZ2 = (this.arg2.minValue() - this.arg2.maxValue()) / (2.0 * (double)this.stepZ);
        }
        return minGradX1 * minGradX2 + minGradY1 * minGradY2 + minGradZ1 * minGradZ2;
    }

    public double maxValue() {
        double maxGradX1 = 0.0;
        double maxGradY1 = 0.0;
        double maxGradZ1 = 0.0;
        double maxGradX2 = 0.0;
        double maxGradY2 = 0.0;
        double maxGradZ2 = 0.0;
        if (this.stepX != 0) {
            maxGradX1 = (this.arg1.maxValue() - this.arg1.minValue()) / (2.0 * (double)this.stepX);
            maxGradX2 = (this.arg2.maxValue() - this.arg2.minValue()) / (2.0 * (double)this.stepX);
        }
        if (this.stepY != 0) {
            maxGradY1 = (this.arg1.maxValue() - this.arg1.minValue()) / (2.0 * (double)this.stepY);
            maxGradY2 = (this.arg2.maxValue() - this.arg2.minValue()) / (2.0 * (double)this.stepY);
        }
        if (this.stepZ != 0) {
            maxGradZ1 = (this.arg1.maxValue() - this.arg1.minValue()) / (2.0 * (double)this.stepZ);
            maxGradZ2 = (this.arg2.maxValue() - this.arg2.minValue()) / (2.0 * (double)this.stepZ);
        }
        return maxGradX1 * maxGradX2 + maxGradY1 * maxGradY2 + maxGradZ1 * maxGradZ2;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }

    private record BlockContext(int blockX, int blockY, int blockZ) implements DensityFunction.FunctionContext
    {
    }
}

