/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Modulo(DensityFunction numerator, DensityFunction denominator) implements DensityFunction
{
    private static final MapCodec<Modulo> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("numerator").forGetter(Modulo::numerator), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("denominator").forGetter(Modulo::denominator)).apply((Applicative)instance, Modulo::new));
    public static final TypedCodec<Modulo> TYPED_CODEC = new TypedCodec("mod", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double numerator, double denominator) {
        return (numerator % denominator + denominator) % denominator;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return Modulo.eval(this.numerator.compute(pos), this.denominator.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Modulo(this.numerator.mapAll(visitor), this.denominator.mapAll(visitor)));
    }

    public double minValue() {
        return StrictMath.min(0.0, Math.nextUp(this.denominator.minValue()));
    }

    public double maxValue() {
        return StrictMath.max(0.0, Math.nextDown(this.denominator.maxValue()));
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

