/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Power(DensityFunction base, DensityFunction exponent) implements DensityFunction
{
    private static final MapCodec<Power> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("base").forGetter(Power::base), (App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("exponent").forGetter(Power::exponent)).apply((Applicative)instance, Power::new));
    public static final TypedCodec<Power> TYPED_CODEC = new TypedCodec("power", KeyDispatchDataCodec.of(MAP_CODEC));

    public double compute(DensityFunction.FunctionContext pos) {
        return StrictMath.pow(this.base.compute(pos), this.exponent.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Power(this.base.mapAll(visitor), this.exponent.mapAll(visitor)));
    }

    public double minValue() {
        return Double.NEGATIVE_INFINITY;
    }

    public double maxValue() {
        return Double.POSITIVE_INFINITY;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

