/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Profiler(DensityFunction arg, int iterations, int warmUp) implements DensityFunction
{
    private static final MapCodec<Profiler> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("argument").forGetter(Profiler::arg), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("iterations").forGetter(Profiler::iterations), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("warm_up").forGetter(Profiler::warmUp)).apply((Applicative)instance, Profiler::new));
    public static final TypedCodec<Profiler> TYPED_CODEC = new TypedCodec("profiler", KeyDispatchDataCodec.of(MAP_CODEC));
    private static final Set<DensityFunction> inactiveProfilers = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public double compute(DensityFunction.FunctionContext pos) {
        int i;
        if (inactiveProfilers.contains(this.arg)) {
            return this.arg.compute(pos);
        }
        System.out.println("\nBeginning Profile of Density Function: " + String.valueOf(this.arg));
        long[] warmUpTimes = new long[this.warmUp];
        long[] iterationTimes = new long[this.iterations];
        for (i = 0; i < this.warmUp; ++i) {
            long startWarmUp = System.nanoTime();
            this.arg.compute(pos);
            long warmupFinish = System.nanoTime();
            warmUpTimes[i] = warmupFinish - startWarmUp;
        }
        System.gc();
        for (i = 0; i < this.iterations; ++i) {
            long startIteration = System.nanoTime();
            this.arg.compute(pos);
            long iterationFinish = System.nanoTime();
            iterationTimes[i] = iterationFinish - startIteration;
        }
        double avgWarmUpTime = Arrays.stream(warmUpTimes).average().orElse(0.0);
        double avgIterationTime = Arrays.stream(iterationTimes).average().orElse(0.0);
        System.out.printf("Profile of %,d iterations:\nAvg. Time per Compute (warm-up stage): %,.3fns\nAvg. Time per Compute (profile stage): %,.3fns\nProfile Time: %,.3fs\n", this.iterations, avgWarmUpTime, avgIterationTime, (avgWarmUpTime * (double)this.warmUp + avgIterationTime * (double)this.iterations) / 1.0E9);
        inactiveProfilers.add(this.arg);
        return this.arg.compute(pos);
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        if (!inactiveProfilers.contains(this.arg)) {
            inactiveProfilers.add(this.arg);
            return new Profiler(this.arg.mapAll(visitor), this.iterations, this.warmUp);
        }
        return visitor.apply(this.arg.mapAll(visitor));
    }

    public double minValue() {
        return this.arg.minValue();
    }

    public double maxValue() {
        return this.arg.maxValue();
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

