/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.serialization.MapCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Radius3D() implements DensityFunction
{
    private static final MapCodec<Radius3D> MAP_CODEC = MapCodec.unit((Object)new Radius3D());
    public static final TypedCodec<Radius3D> TYPED_CODEC = new TypedCodec("radius_3d", KeyDispatchDataCodec.of(MAP_CODEC));

    public double compute(DensityFunction.FunctionContext pos) {
        return StrictMath.sqrt(pos.blockX() * pos.blockX() + pos.blockY() * pos.blockY() + pos.blockZ() * pos.blockZ());
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Radius3D());
    }

    public double minValue() {
        return 0.0;
    }

    public double maxValue() {
        return (double)Mth.SQRT_OF_TWO * 3.3554431E7;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

