/*
 * Decompiled with CFR 0.152.
 */
package com.klinbee.moredensityfunctions.densityfunctions;

import com.klinbee.moredensityfunctions.registration.TypedCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;

public record Reciprocal(DensityFunction denominator) implements DensityFunction
{
    private static final MapCodec<Reciprocal> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DensityFunction.HOLDER_HELPER_CODEC.fieldOf("denominator").forGetter(Reciprocal::denominator)).apply((Applicative)instance, Reciprocal::new));
    public static final TypedCodec<Reciprocal> TYPED_CODEC = new TypedCodec("reciprocal", KeyDispatchDataCodec.of(MAP_CODEC));

    private static double eval(double density) {
        return 1.0 / density;
    }

    public double compute(DensityFunction.FunctionContext pos) {
        return Reciprocal.eval(this.denominator.compute(pos));
    }

    public void fillArray(double[] densities, DensityFunction.ContextProvider applier) {
        applier.fillAllDirectly(densities, (DensityFunction)this);
    }

    public DensityFunction mapAll(DensityFunction.Visitor visitor) {
        return visitor.apply((DensityFunction)new Reciprocal(this.denominator.mapAll(visitor)));
    }

    public double minValue() {
        double asymptoteLocation = 0.0;
        double denomMin = this.denominator.minValue();
        double denomMax = this.denominator.maxValue();
        if (denomMin > asymptoteLocation) {
            return Reciprocal.eval(denomMax);
        }
        if (denomMax < asymptoteLocation) {
            return Reciprocal.eval(denomMax);
        }
        return Double.NaN;
    }

    public double maxValue() {
        double asymptoteLocation = 0.0;
        double denomMin = this.denominator.minValue();
        if (denomMin > asymptoteLocation) {
            return Reciprocal.eval(denomMin);
        }
        double denomMax = this.denominator.maxValue();
        if (denomMax < asymptoteLocation) {
            return Reciprocal.eval(denomMin);
        }
        return Double.NaN;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> codec() {
        return TYPED_CODEC.codec();
    }
}

